/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.observation.transport.ReceiverContext;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.header.Header;

public class KafkaRecordReceiverContext
extends ReceiverContext<ConsumerRecord<?, ?>> {
    private final String listenerId;
    private final ConsumerRecord<?, ?> record;

    public KafkaRecordReceiverContext(ConsumerRecord<?, ?> record, String listenerId, Supplier<String> clusterId) {
        super((carrier, key) -> {
            Header header = carrier.headers().lastHeader(key);
            if (header == null) {
                return null;
            }
            return new String(header.value(), StandardCharsets.UTF_8);
        });
        this.setCarrier(record);
        this.record = record;
        this.listenerId = listenerId;
        String cluster = clusterId.get();
        this.setRemoteServiceName("Apache Kafka" + (String)(cluster != null ? ": " + cluster : ""));
    }

    public String getListenerId() {
        return this.listenerId;
    }

    public String getSource() {
        return this.record.topic();
    }

    public ConsumerRecord<?, ?> getRecord() {
        return this.record;
    }
}

