/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.internals.ShareAcknowledgementMode;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerEndpointAdapter;
import org.springframework.kafka.core.ShareConsumerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.ShareKafkaMessageListenerContainer;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.util.Assert;

public class ShareKafkaListenerContainerFactory<K, V>
implements KafkaListenerContainerFactory<ShareKafkaMessageListenerContainer<K, V>>,
ApplicationEventPublisherAware,
ApplicationContextAware {
    private final ShareConsumerFactory<? super K, ? super V> shareConsumerFactory;
    private final ContainerProperties containerProperties = new ContainerProperties((Pattern)null);
    private boolean autoStartup = true;
    private int phase = 0;
    private int concurrency = 1;
    private ApplicationEventPublisher applicationEventPublisher;
    private ApplicationContext applicationContext;

    public ShareKafkaListenerContainerFactory(ShareConsumerFactory<K, V> shareConsumerFactory) {
        this.shareConsumerFactory = shareConsumerFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setConcurrency(int concurrency) {
        this.concurrency = concurrency;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createListenerContainer(KafkaListenerEndpoint endpoint) {
        ShareKafkaMessageListenerContainer<K, V> instance = this.createContainerInstance(endpoint);
        JavaUtils.INSTANCE.acceptIfNotNull(endpoint.getId(), instance::setBeanName);
        if (endpoint instanceof AbstractKafkaListenerEndpoint) {
            AbstractKafkaListenerEndpoint abstractKafkaListenerEndpoint = (AbstractKafkaListenerEndpoint)endpoint;
            this.configureEndpoint(abstractKafkaListenerEndpoint);
        }
        endpoint.setupListenerContainer(instance, null);
        this.initializeContainer(instance, endpoint);
        return instance;
    }

    private void configureEndpoint(AbstractKafkaListenerEndpoint<K, V> endpoint) {
    }

    protected void initializeContainer(ShareKafkaMessageListenerContainer<K, V> instance, KafkaListenerEndpoint endpoint) {
        ContainerProperties properties = instance.getContainerProperties();
        boolean effectiveAutoStartup = endpoint.getAutoStartup() != null ? endpoint.getAutoStartup() : this.autoStartup;
        ShareKafkaListenerContainerFactory.validateShareConfiguration(endpoint);
        BeanUtils.copyProperties((Object)this.containerProperties, (Object)properties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "messageListener", "ackCount", "ackTime", "subBatchPerPartition", "kafkaConsumerProperties"});
        boolean explicitAck = this.determineExplicitAcknowledgment(properties);
        properties.setExplicitShareAcknowledgment(explicitAck);
        Integer conc = endpoint.getConcurrency();
        if (conc != null) {
            instance.setConcurrency(conc);
        } else {
            instance.setConcurrency(this.concurrency);
        }
        instance.setAutoStartup(effectiveAutoStartup);
        instance.setPhase(this.phase);
        instance.setApplicationContext(this.applicationContext);
        instance.setApplicationEventPublisher(this.applicationEventPublisher);
        JavaUtils.INSTANCE.acceptIfNotNull(endpoint.getGroupId(), properties::setGroupId).acceptIfNotNull(endpoint.getClientIdPrefix(), properties::setClientId);
    }

    private boolean determineExplicitAcknowledgment(ContainerProperties containerProperties) {
        if (this.containerProperties.isExplicitShareAcknowledgment()) {
            return true;
        }
        Object clientAckMode = this.shareConsumerFactory.getConfigurationProperties().get("share.acknowledgement.mode");
        if (clientAckMode != null) {
            ShareAcknowledgementMode mode = ShareAcknowledgementMode.fromString((String)clientAckMode.toString());
            return mode == ShareAcknowledgementMode.EXPLICIT;
        }
        return false;
    }

    private static void validateShareConfiguration(KafkaListenerEndpoint endpoint) {
        if (Boolean.TRUE.equals(endpoint.getBatchListener())) {
            throw new IllegalArgumentException("Batch listeners are not supported with share consumers. Share groups operate at the record level.");
        }
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createContainer(TopicPartitionOffset ... topicPartitions) {
        throw new UnsupportedOperationException("ShareConsumer does not support explicit partition assignment");
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createContainer(final String ... topics) {
        return this.createContainerInstance(new KafkaListenerEndpointAdapter(this){
            final /* synthetic */ ShareKafkaListenerContainerFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        });
    }

    @Override
    public ShareKafkaMessageListenerContainer<K, V> createContainer(Pattern topicPattern) {
        throw new UnsupportedOperationException("ShareConsumer does not support topic patterns");
    }

    protected ShareKafkaMessageListenerContainer<K, V> createContainerInstance(KafkaListenerEndpoint endpoint) {
        Collection<String> topics = endpoint.getTopics();
        Assert.state((topics != null ? 1 : 0) != 0, (String)"'topics' must not be null");
        return new ShareKafkaMessageListenerContainer<K, V>(this.shareConsumerFactory, new ContainerProperties(topics.toArray(new String[0])));
    }
}

