/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.requestreply;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;

public final class CorrelationKey {
    private static final char[] HEX_ARRAY = "0123456789abcdef".toCharArray();
    private final byte[] correlationId;
    private @Nullable String asString;
    private volatile @Nullable Integer hashCode;

    public CorrelationKey(byte[] correlationId) {
        Assert.notNull((Object)correlationId, (String)"'correlationId' cannot be null");
        this.correlationId = correlationId;
    }

    public byte[] getCorrelationId() {
        return this.correlationId;
    }

    public int hashCode() {
        if (this.hashCode != null) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.correlationId);
        this.hashCode = result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrelationKey other = (CorrelationKey)obj;
        return Arrays.equals(this.correlationId, other.correlationId);
    }

    private static String bytesToHex(byte[] bytes) {
        boolean uuid = bytes.length == 16;
        char[] hexChars = new char[bytes.length * 2 + (uuid ? 4 : 0)];
        int i = 0;
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[i++] = HEX_ARRAY[v >>> 4];
            hexChars[i++] = HEX_ARRAY[v & 0xF];
            if (!uuid || j != 3 && j != 5 && j != 7 && j != 9) continue;
            hexChars[i++] = 45;
        }
        return new String(hexChars);
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = CorrelationKey.bytesToHex(this.correlationId);
        }
        return this.asString;
    }
}

