/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.test.AbstractEc2InstanceLaunchingFactoryBean;
import org.springframework.util.Assert;

public class ContextSourceEc2InstanceLaunchingFactoryBean
extends AbstractEc2InstanceLaunchingFactoryBean {
    private String base;
    private String userDn;
    private String password;
    private boolean pooled = false;

    public final Class getObjectType() {
        return ContextSource.class;
    }

    protected final Object doCreateInstance(String dnsName) throws Exception {
        Assert.hasText((String)this.userDn);
        LdapContextSource instance = new LdapContextSource();
        instance.setUrl("ldap://" + dnsName);
        instance.setUserDn(this.userDn);
        instance.setPassword(this.password);
        instance.setBase(this.base);
        instance.setPooled(this.pooled);
        this.setAdditionalContextSourceProperties(instance, dnsName);
        instance.afterPropertiesSet();
        return instance;
    }

    public void setPooled(boolean pooled) {
        this.pooled = pooled;
    }

    protected void setAdditionalContextSourceProperties(LdapContextSource ctx, String dnsName) {
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

