/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.test;

import java.io.File;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.ldap.LdapServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.shared.ldap.name.LdapDN;

public class EmbeddedLdapServer {
    private final DirectoryService directoryService;
    private final LdapServer ldapServer;

    private EmbeddedLdapServer(DirectoryService directoryService, LdapServer ldapServer) {
        this.directoryService = directoryService;
        this.ldapServer = ldapServer;
    }

    public static EmbeddedLdapServer newEmbeddedServer(String defaultPartitionName, String defaultPartitionSuffix, int port) throws Exception {
        DefaultDirectoryService directoryService = new DefaultDirectoryService();
        directoryService.setShutdownHookEnabled(true);
        directoryService.setAllowAnonymousAccess(true);
        directoryService.setWorkingDirectory(new File(System.getProperty("java.io.tmpdir") + "/apacheds-test"));
        directoryService.getChangeLog().setEnabled(false);
        JdbmPartition partition = new JdbmPartition();
        partition.setId(defaultPartitionName);
        partition.setSuffix(defaultPartitionSuffix);
        directoryService.addPartition((Partition)partition);
        directoryService.startup();
        if (!directoryService.getAdminSession().exists(partition.getSuffixDn())) {
            ServerEntry entry = directoryService.newEntry(new LdapDN(defaultPartitionSuffix));
            entry.add("objectClass", new String[]{"top", "domain", "extensibleObject"});
            entry.add("dc", new String[]{defaultPartitionName});
            directoryService.getAdminSession().add(entry);
        }
        LdapServer ldapServer = new LdapServer();
        ldapServer.setDirectoryService((DirectoryService)directoryService);
        TcpTransport ldapTransport = new TcpTransport(port);
        ldapServer.setTransports(new Transport[]{ldapTransport});
        ldapServer.start();
        return new EmbeddedLdapServer((DirectoryService)directoryService, ldapServer);
    }

    public void shutdown() throws Exception {
        this.ldapServer.stop();
        this.directoryService.shutdown();
    }
}

