/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.view;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.springframework.util.Assert;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractDeviceDelegatingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    public static final String FORWARD_URL_PREFIX = "forward:";
    private final ViewResolver delegate;
    private boolean enableFallback = false;

    protected AbstractDeviceDelegatingViewResolver(ViewResolver delegate) {
        Assert.notNull((Object)delegate, (String)"delegate is required");
        this.delegate = delegate;
    }

    public ViewResolver getViewResolver() {
        return this.delegate;
    }

    public void setEnableFallback(boolean enableFallback) {
        this.enableFallback = enableFallback;
    }

    protected boolean getEnableFallback() {
        return this.enableFallback;
    }

    public View resolveViewName(String viewName, Locale locale) throws Exception {
        String deviceViewName = this.getDeviceViewName(viewName);
        View view = this.delegate.resolveViewName(deviceViewName, locale);
        if (this.enableFallback && view == null) {
            view = this.delegate.resolveViewName(viewName, locale);
        }
        return view;
    }

    protected String getDeviceViewName(String viewName) {
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length());
            if (this.isAbsoluteUrl(redirectUrl)) {
                return viewName;
            }
            return REDIRECT_URL_PREFIX + this.getDeviceViewNameInternal(redirectUrl);
        }
        if (viewName.startsWith(FORWARD_URL_PREFIX)) {
            String forwardUrl = viewName.substring(FORWARD_URL_PREFIX.length());
            if (this.isAbsoluteUrl(forwardUrl)) {
                return viewName;
            }
            return FORWARD_URL_PREFIX + this.getDeviceViewNameInternal(forwardUrl);
        }
        return this.getDeviceViewNameInternal(viewName);
    }

    private boolean isAbsoluteUrl(String url) {
        try {
            URI uri = new URI(url);
            return uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    protected abstract String getDeviceViewNameInternal(String var1);

    protected void initServletContext(ServletContext servletContext) {
        String name = this.delegate.getClass().getName();
        this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)this.delegate, name);
    }
}

