/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.events;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.modulith.events.EventExternalizationConfiguration;
import org.springframework.modulith.events.RoutingTarget;
import org.springframework.util.Assert;

class DefaultEventExternalizationConfiguration
implements EventExternalizationConfiguration {
    private final Predicate<Object> filter;
    private final Function<Object, Object> mapper;
    private final Function<Object, RoutingTarget> router;
    private final Function<Object, Map<String, Object>> headers;

    DefaultEventExternalizationConfiguration(Predicate<Object> filter, Function<Object, Object> mapper, Function<Object, RoutingTarget> router, Function<Object, Map<String, Object>> headers) {
        Assert.notNull(filter, (String)"Filter must not be null!");
        Assert.notNull(mapper, (String)"Mapper must not be null!");
        Assert.notNull(router, (String)"Router must not be null!");
        this.filter = filter;
        this.mapper = mapper;
        this.router = router;
        this.headers = headers;
    }

    static EventExternalizationConfiguration.Selector builder() {
        return new EventExternalizationConfiguration.Selector();
    }

    @Override
    public boolean supports(Object event) {
        Assert.notNull((Object)event, (String)"Event must not be null!");
        return this.filter.test(event);
    }

    @Override
    public Object map(Object event) {
        Assert.notNull((Object)event, (String)"Event must not be null!");
        return this.mapper.apply(event);
    }

    @Override
    public RoutingTarget determineTarget(Object event) {
        Assert.notNull((Object)event, (String)"Event must not be null!");
        return this.router.apply(event).verify();
    }

    @Override
    public Map<String, Object> getHeadersFor(Object event) {
        Assert.notNull((Object)event, (String)"Event must not be null!");
        return this.headers.apply(event);
    }
}

