/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.moments;

import java.time.Month;
import java.time.MonthDay;
import org.springframework.util.Assert;

public enum Quarter {
    Q1(MonthDay.of(Month.JANUARY, 1), MonthDay.of(Month.MARCH, 31)),
    Q2(MonthDay.of(Month.APRIL, 1), MonthDay.of(Month.JUNE, 30)),
    Q3(MonthDay.of(Month.JULY, 1), MonthDay.of(Month.SEPTEMBER, 30)),
    Q4(MonthDay.of(Month.OCTOBER, 1), MonthDay.of(Month.DECEMBER, 31));

    private final MonthDay start;
    private final MonthDay end;

    private Quarter(MonthDay start, MonthDay end) {
        Assert.notNull((Object)start, (String)"Start MonthDay must not be null!");
        Assert.notNull((Object)end, (String)"End MonthDay must not be null!");
        this.start = start;
        this.end = end;
    }

    public MonthDay getStart() {
        return this.start;
    }

    public MonthDay getEnd() {
        return this.end;
    }

    Quarter next() {
        switch (this) {
            case Q1: {
                return Q2;
            }
            case Q2: {
                return Q3;
            }
            case Q3: {
                return Q4;
            }
            case Q4: {
                return Q1;
            }
        }
        throw new IllegalStateException("\u00af\\_(\u30c4)_/\u00af");
    }
}

