/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.moments;

import java.time.LocalDate;
import java.time.Year;
import java.time.temporal.ChronoField;
import java.time.temporal.WeekFields;
import java.util.Locale;
import java.util.Objects;
import org.jmolecules.event.types.DomainEvent;
import org.springframework.util.Assert;

public class WeekHasPassed
implements DomainEvent {
    private final Year year;
    private final int week;
    private final Locale locale;

    WeekHasPassed(Year year, int week, Locale locale) {
        Assert.notNull((Object)year, (String)"Year must not be null!");
        Assert.isTrue((week >= 0 && week <= 53 ? 1 : 0) != 0, (String)"Week must be between 0 and 53!");
        Assert.notNull((Object)locale, (String)"Locale must not be null!");
        this.year = year;
        this.week = week;
        this.locale = locale;
    }

    public static WeekHasPassed of(Year year, int week, Locale locale) {
        return new WeekHasPassed(year, week, locale);
    }

    public static WeekHasPassed of(Year year, int week) {
        return WeekHasPassed.of(year, week, Locale.getDefault());
    }

    public Year getYear() {
        return this.year;
    }

    public int getWeek() {
        return this.week;
    }

    public LocalDate getStartDate() {
        return LocalDate.of(this.year.getValue(), 1, 1).with(WeekFields.of(this.locale).weekOfYear(), this.week).with(ChronoField.DAY_OF_WEEK, 1L);
    }

    public LocalDate getEndDate() {
        return this.getStartDate().plusDays(6L);
    }

    Locale getLocale() {
        return this.locale;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WeekHasPassed)) {
            return false;
        }
        WeekHasPassed that = (WeekHasPassed)obj;
        return this.week == that.week && Objects.equals(this.year, that.year) && Objects.equals(this.locale, that.locale);
    }

    public int hashCode() {
        return Objects.hash(this.locale, this.week, this.year);
    }
}

