/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extensions.annotation;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.extensions.annotation.ServiceReference;
import org.springframework.osgi.service.importer.support.AbstractOsgiServiceImportFactoryBean;
import org.springframework.osgi.service.importer.support.CollectionType;
import org.springframework.osgi.service.importer.support.OsgiServiceCollectionProxyFactoryBean;
import org.springframework.osgi.service.importer.support.OsgiServiceProxyFactoryBean;
import org.springframework.util.ReflectionUtils;

public class ServiceReferenceInjectionBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BundleContextAware,
BeanFactoryAware,
BeanClassLoaderAware {
    private BundleContext bundleContext;
    private static Log logger = LogFactory.getLog(ServiceReferenceInjectionBeanPostProcessor.class);
    private BeanFactory beanFactory;
    private ClassLoader classLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processing [" + bean.getClass().getName() + ", " + beanName + "]"));
        }
        if (!(bean instanceof FactoryBean) && this.beanFactory.containsBean("&" + beanName)) {
            this.injectServices(bean, beanName);
        }
        return bean;
    }

    private void injectServices(final Object bean, final String beanName) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                ServiceReference s = (ServiceReference)AnnotationUtils.getAnnotation((Method)method, ServiceReference.class);
                if (s != null && method.getParameterTypes().length == 1) {
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Processing annotation [" + s + "] for [" + bean.getClass().getName() + "." + method.getName() + "()] on bean [" + beanName + "]"));
                        }
                        method.invoke(bean, ServiceReferenceInjectionBeanPostProcessor.this.getServiceProperty(s, method, beanName));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Error processing service annotation", e);
                    }
                }
            }
        });
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        MutablePropertyValues newprops = new MutablePropertyValues(pvs);
        for (PropertyDescriptor pd : pds) {
            ServiceReference s = this.hasServiceProperty(pd);
            if (s == null || pvs.contains(pd.getName())) continue;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Processing annotation [" + s + "] for [" + beanName + "." + pd.getName() + "]"));
                }
                newprops.addPropertyValue(pd.getName(), this.getServiceProperty(s, pd.getWriteMethod(), beanName));
            }
            catch (Exception e) {
                throw new FatalBeanException("Could not create service reference", (Throwable)e);
            }
        }
        return newprops;
    }

    private Object getServiceProperty(ServiceReference s, Method writeMethod, String beanName) throws Exception {
        Class<?>[] params = writeMethod.getParameterTypes();
        if (params.length != 1) {
            throw new IllegalArgumentException("Setter for [" + beanName + "] must have only one argument");
        }
        if (Collection.class.isAssignableFrom(params[0])) {
            return this.getServiceProperty(new OsgiServiceCollectionProxyFactoryBean(), s, writeMethod, beanName).getObject();
        }
        return this.getServiceProperty(new OsgiServiceProxyFactoryBean(), s, writeMethod, beanName).getObject();
    }

    private AbstractOsgiServiceImportFactoryBean getServicePropertyInternal(AbstractOsgiServiceImportFactoryBean pfb, ServiceReference s, Method writeMethod, String beanName) throws Exception {
        if (s.filter().length() > 0) {
            pfb.setFilter(s.filter());
        }
        if (s.serviceTypes() == null || s.serviceTypes().length == 0 || s.serviceTypes().length == 1 && s.serviceTypes()[0].equals(ServiceReference.class)) {
            Class<?>[] params = writeMethod.getParameterTypes();
            if (params.length != 1) {
                throw new IllegalArgumentException("Setter for [" + beanName + "] must have only one argument");
            }
            pfb.setInterfaces(new Class[]{params[0]});
        } else {
            pfb.setInterfaces((Class[])s.serviceTypes());
        }
        pfb.setCardinality(s.cardinality().toCardinality());
        pfb.setContextClassLoader(s.contextClassLoader().toImportContextClassLoader());
        pfb.setBundleContext(this.bundleContext);
        if (s.serviceBeanName().length() > 0) {
            pfb.setServiceBeanName(s.serviceBeanName());
        }
        pfb.setBeanClassLoader(this.classLoader);
        pfb.afterPropertiesSet();
        return pfb;
    }

    AbstractOsgiServiceImportFactoryBean getServiceProperty(OsgiServiceProxyFactoryBean pfb, ServiceReference s, Method writeMethod, String beanName) throws Exception {
        pfb.setTimeout((long)s.timeout());
        return this.getServicePropertyInternal((AbstractOsgiServiceImportFactoryBean)pfb, s, writeMethod, beanName);
    }

    AbstractOsgiServiceImportFactoryBean getServiceProperty(OsgiServiceCollectionProxyFactoryBean pfb, ServiceReference s, Method writeMethod, String beanName) throws Exception {
        Class<?>[] params = writeMethod.getParameterTypes();
        if (SortedSet.class.isAssignableFrom(params[0])) {
            pfb.setCollectionType(CollectionType.SORTED_SET);
        } else if (Set.class.isAssignableFrom(params[0])) {
            pfb.setCollectionType(CollectionType.SET);
        } else if (List.class.isAssignableFrom(params[0])) {
            pfb.setCollectionType(CollectionType.LIST);
        } else {
            throw new IllegalArgumentException("Setter for [" + beanName + "] does not have a valid Collection type argument");
        }
        return this.getServicePropertyInternal((AbstractOsgiServiceImportFactoryBean)pfb, s, writeMethod, beanName);
    }

    protected ServiceReference hasServiceProperty(PropertyDescriptor propertyDescriptor) {
        Method setter = propertyDescriptor.getWriteMethod();
        return setter != null ? (ServiceReference)AnnotationUtils.getAnnotation((Method)setter, ServiceReference.class) : null;
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

