/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.Version;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.context.ConfigurableOsgiBundleApplicationContext;
import org.springframework.osgi.context.DelegatedExecutionOsgiBundleApplicationContext;
import org.springframework.osgi.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.osgi.extender.internal.dependencies.shutdown.ComparatorServiceDependencySorter;
import org.springframework.osgi.extender.internal.dependencies.shutdown.ServiceDependencySorter;
import org.springframework.osgi.extender.internal.dependencies.startup.DependencyWaiterApplicationContextExecutor;
import org.springframework.osgi.extender.internal.support.ApplicationContextConfiguration;
import org.springframework.osgi.extender.internal.support.NamespaceManager;
import org.springframework.osgi.extender.internal.util.ConfigUtils;
import org.springframework.osgi.extender.internal.util.concurrent.Counter;
import org.springframework.osgi.extender.internal.util.concurrent.RunnableTimedExecution;
import org.springframework.osgi.util.OsgiBundleUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.ObjectUtils;

public class ContextLoaderListener
implements BundleActivator {
    protected static final String EXTENDER_CONFIG_FILE_LOCATION = "META-INF/spring/extender.xml";
    protected static final String TASK_EXECUTOR_BEAN_NAME = "taskExecutor";
    private static final String AUTO_ANNOTATION_PROCESSING = "org.springframework.osgi.extender.annotation.auto.processing";
    private static final long SHUTDOWN_WAIT_TIME = 10000L;
    private static final String ANNOTATION_BPP_CLASS = "org.springframework.osgi.extensions.annotation.ServiceReferenceInjectionBeanPostProcessor";
    private static final Log log = LogFactory.getLog((Class)ContextLoaderListener.class);
    protected Timer timer = new Timer(true);
    protected long bundleId;
    protected OsgiBundleXmlApplicationContext extenderContext;
    protected final Map managedContexts;
    protected final Set springBundleListeners = new LinkedHashSet();
    protected TaskExecutor taskExecutor;
    private TaskExecutor sameThreadTaskExecutor = new SyncTaskExecutor();
    private ThreadGroup threadGroup;
    protected boolean isTaskExecutorManagedInternally = false;
    protected Counter contextsStarted = new Counter("contextsStarted");
    protected ServiceRegistration listenerServiceRegistration;
    private NamespaceManager nsManager;
    protected BundleContext context;
    private SynchronousBundleListener contextListener;
    private SynchronousBundleListener nsListener;
    private ServiceDependencySorter shutdownDependencySorter = new ComparatorServiceDependencySorter();
    private final transient Object monitor = new Object();
    private boolean isClosed = false;
    private Version extenderVersion;

    public ContextLoaderListener() {
        this.managedContexts = CollectionFactory.createConcurrentMap((int)16);
    }

    public void start(BundleContext context) throws Exception {
        int i;
        this.extenderVersion = OsgiBundleUtils.getBundleVersion((Bundle)context.getBundle());
        log.info((Object)("Starting org.springframework.osgi.extender bundle v.[" + this.extenderVersion + "]"));
        this.context = context;
        this.bundleId = context.getBundle().getBundleId();
        this.nsManager = new NamespaceManager(context);
        this.nsListener = new NamespaceBundleLister();
        context.addBundleListener((BundleListener)this.nsListener);
        Bundle[] previousBundles = context.getBundles();
        for (i = 0; i < previousBundles.length; ++i) {
            Bundle bundle = previousBundles[i];
            if (!OsgiBundleUtils.isBundleResolved((Bundle)bundle)) continue;
            this.maybeAddNamespaceHandlerFor(bundle);
        }
        this.nsManager.afterPropertiesSet();
        this.taskExecutor = this.createTaskExecutor(context);
        this.contextListener = new ContextBundleListener();
        context.addBundleListener((BundleListener)this.contextListener);
        previousBundles = context.getBundles();
        for (i = 0; i < previousBundles.length; ++i) {
            if (!OsgiBundleUtils.isBundleActive((Bundle)previousBundles[i])) continue;
            try {
                this.maybeCreateApplicationContextFor(previousBundles[i]);
                continue;
            }
            catch (Throwable e) {
                log.warn((Object)("Cannot start bundle " + OsgiStringUtils.nullSafeSymbolicName((Bundle)previousBundles[i]) + " due to"), e);
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        log.info((Object)"Stopping org.springframework.osgi.extender bundle");
        this.stopTimer();
        if (this.contextListener != null) {
            this.context.removeBundleListener((BundleListener)this.contextListener);
            this.contextListener = null;
        }
        if (this.nsListener != null) {
            this.context.removeBundleListener((BundleListener)this.nsListener);
            this.nsListener = null;
        }
        Bundle[] bundles = new Bundle[this.managedContexts.size()];
        int i = 0;
        Iterator it = this.managedContexts.values().iterator();
        while (it.hasNext()) {
            ConfigurableOsgiBundleApplicationContext context = (ConfigurableOsgiBundleApplicationContext)it.next();
            bundles[i++] = context.getBundle();
        }
        bundles = this.shutdownDependencySorter.computeServiceDependencyGraph(bundles);
        boolean debug = log.isDebugEnabled();
        StringBuffer buffer = new StringBuffer();
        if (debug) {
            buffer.append("Shutdown order is: {");
            for (i = 0; i < bundles.length; ++i) {
                buffer.append("\nBundle [" + bundles[i].getSymbolicName() + "]");
            }
            buffer.append("\n}");
            log.debug((Object)buffer);
        }
        ArrayList<1> taskList = new ArrayList<1>(this.managedContexts.size());
        final List<ConfigurableOsgiBundleApplicationContext> closedContexts = Collections.synchronizedList(new ArrayList());
        final Object[] contextClosingDown = new Object[1];
        for (i = 0; i < bundles.length; ++i) {
            Long id = new Long(bundles[i].getBundleId());
            final ConfigurableOsgiBundleApplicationContext context = (ConfigurableOsgiBundleApplicationContext)this.managedContexts.get(id);
            if (context == null) continue;
            closedContexts.add(context);
            taskList.add(new Runnable(){

                public void run() {
                    contextClosingDown[0] = context;
                    closedContexts.remove(context);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Closing appCtx " + context.getDisplayName()));
                    }
                    context.close();
                }
            });
        }
        Runnable[] tasks = taskList.toArray(new Runnable[taskList.size()]);
        for (int j = 0; j < tasks.length; ++j) {
            if (!RunnableTimedExecution.execute(tasks[j], 10000L) || !debug) continue;
            log.debug((Object)(contextClosingDown[0] + " context did not closed succesfully; forcing shutdown"));
        }
        this.managedContexts.clear();
        this.nsManager.destroy();
        this.taskExecutor = null;
        if (this.extenderContext != null) {
            this.extenderContext.close();
            this.extenderContext = null;
        }
        this.stopTaskExecutor();
    }

    private void stopTimer() {
        if (this.timer != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Canceling timer tasks");
            }
            this.timer.cancel();
        }
        this.timer = null;
    }

    private void stopTaskExecutor() {
        boolean debug = log.isDebugEnabled();
        if (this.taskExecutor != null && this.isTaskExecutorManagedInternally) {
            if (debug) {
                log.debug((Object)("Waiting for " + this.contextsStarted + " service dependency listener(s) to stop..."));
            }
            this.contextsStarted.waitForZero(10000L);
            if (!this.contextsStarted.isZero()) {
                if (debug) {
                    log.debug((Object)(this.contextsStarted.getValue() + " service dependency listener(s) did not responded in time; forcing them to shutdown"));
                }
                if (this.threadGroup != null) {
                    this.threadGroup.stop();
                    this.threadGroup = null;
                }
            } else {
                log.debug((Object)"All listeners closed");
            }
        }
    }

    private boolean handlerBundleMatchesExtenderVersion(Bundle bundle) {
        if (!ConfigUtils.matchExtenderVersionRange(bundle, this.extenderVersion)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "] expects an extender w/ version[" + OsgiBundleUtils.getHeaderAsVersion((Bundle)bundle, (String)"SpringExtender-Version") + "] which does not match current extender w/ version[" + this.extenderVersion + "]; skipping bundle from handler detection"));
            }
            return false;
        }
        return true;
    }

    private void maybeAddNamespaceHandlerFor(Bundle bundle) {
        if (this.handlerBundleMatchesExtenderVersion(bundle)) {
            this.nsManager.maybeAddNamespaceHandlerFor(bundle);
        }
    }

    private void maybeRemoveNameSpaceHandlerFor(Bundle bundle) {
        if (this.handlerBundleMatchesExtenderVersion(bundle)) {
            this.nsManager.maybeRemoveNameSpaceHandlerFor(bundle);
        }
    }

    protected void maybeCreateApplicationContextFor(Bundle bundle) {
        if (!ConfigUtils.matchExtenderVersionRange(bundle, this.extenderVersion)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bundle [" + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle) + "] expects an extender w/ version[" + OsgiBundleUtils.getHeaderAsVersion((Bundle)bundle, (String)"SpringExtender-Version") + "] which does not match current extender w/ version[" + this.extenderVersion + "]; skipping bundle from context creation"));
            }
            return;
        }
        ApplicationContextConfiguration config = new ApplicationContextConfiguration(bundle);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created config " + config));
        }
        if (!config.isSpringPoweredBundle()) {
            return;
        }
        Long bundleId = new Long(bundle.getBundleId());
        final DelegatedExecutionOsgiBundleApplicationContext context = this.createApplicationContext(OsgiBundleUtils.getBundleContext((Bundle)bundle), config.getConfigurationLocations());
        if (this.managedContexts.containsKey(bundleId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bundle is already under control: " + bundle.getSymbolicName()));
            }
            return;
        }
        this.managedContexts.put(bundleId, context);
        context.setPublishContextAsService(config.isPublishContextAsService());
        Runnable contextRefresh = new Runnable(){

            public void run() {
                context.refresh();
            }
        };
        TaskExecutor executor = null;
        if (config.isCreateAsynchronously()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Asynchronous context creation for bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
            }
            executor = this.taskExecutor;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Synchronous context creation for bundle " + OsgiStringUtils.nullSafeNameAndSymName((Bundle)bundle)));
            }
            executor = this.sameThreadTaskExecutor;
        }
        if (config.isWaitForDependencies()) {
            DependencyWaiterApplicationContextExecutor appCtxExecutor = new DependencyWaiterApplicationContextExecutor(context, !config.isCreateAsynchronously());
            appCtxExecutor.setTimeout(config.getTimeout());
            appCtxExecutor.setWatchdog(this.timer);
            appCtxExecutor.setTaskExecutor(executor);
            appCtxExecutor.setMonitoringCounter(this.contextsStarted);
            this.contextsStarted.increment();
        }
        executor.execute(contextRefresh);
    }

    protected DelegatedExecutionOsgiBundleApplicationContext createApplicationContext(BundleContext context, String[] locations) {
        OsgiBundleXmlApplicationContext sdoac = new OsgiBundleXmlApplicationContext(locations);
        sdoac.setBundleContext(context);
        this.postProcessContext((DelegatedExecutionOsgiBundleApplicationContext)sdoac);
        return sdoac;
    }

    protected void postProcessContext(DelegatedExecutionOsgiBundleApplicationContext applicationContext) {
        this.addAnnotationBPP(applicationContext);
    }

    private void addAnnotationBPP(DelegatedExecutionOsgiBundleApplicationContext applicationContext) {
        Map config = this.getExternalConfiguration();
        Object setting = config.get(AUTO_ANNOTATION_PROCESSING);
        if (setting != null && setting instanceof String && Boolean.getBoolean((String)setting)) {
            log.info((Object)("Enabled automatic Spring-DM annotation processing; [org.springframework.osgi.extender.annotation.auto.processing=" + setting + "]"));
            try {
                Class annotationBppClass = this.context.getBundle().loadClass(ANNOTATION_BPP_CLASS);
                final BeanPostProcessor annotationBpp = (BeanPostProcessor)BeanUtils.instantiateClass((Class)annotationBppClass);
                ((BundleContextAware)annotationBpp).setBundleContext(this.context);
                applicationContext.addBeanFactoryPostProcessor(new BeanFactoryPostProcessor(){

                    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                        ((BeanFactoryAware)annotationBpp).setBeanFactory((BeanFactory)beanFactory);
                        ((BeanClassLoaderAware)annotationBpp).setBeanClassLoader(beanFactory.getBeanClassLoader());
                        beanFactory.addBeanPostProcessor(annotationBpp);
                    }
                });
            }
            catch (ClassNotFoundException exception) {
                log.info((Object)"Spring-dm annotation package cannot be found; automatic annotation processing is disabled");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cannot load annotatoin bpp", (Throwable)exception);
                }
            }
        } else {
            log.info((Object)("Disabled automatic Spring-DM annotation processing; [ org.springframework.osgi.extender.annotation.auto.processing=" + setting + "]"));
        }
    }

    protected Map getExternalConfiguration() {
        return System.getProperties();
    }

    protected void maybeCloseApplicationContextFor(Bundle bundle) {
        final ConfigurableOsgiBundleApplicationContext context = (ConfigurableOsgiBundleApplicationContext)this.managedContexts.remove(new Long(bundle.getBundleId()));
        if (context == null) {
            return;
        }
        RunnableTimedExecution.execute(new Runnable(){

            public void run() {
                context.close();
            }
        }, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskExecutor createTaskExecutor(BundleContext context) {
        String[] locations;
        Bundle extenderBundle = context.getBundle();
        URL extenderConfigFile = extenderBundle.getResource(EXTENDER_CONFIG_FILE_LOCATION);
        if (extenderConfigFile != null) {
            locations = new String[]{extenderConfigFile.toExternalForm()};
            this.extenderContext = new OsgiBundleXmlApplicationContext(locations);
            this.extenderContext.setBundleContext(context);
            this.extenderContext.refresh();
            if (this.extenderContext.containsBean(TASK_EXECUTOR_BEAN_NAME)) {
                Object taskExecutor = this.extenderContext.getBean(TASK_EXECUTOR_BEAN_NAME);
                if (taskExecutor instanceof TaskExecutor) {
                    return (TaskExecutor)taskExecutor;
                }
                if (log.isErrorEnabled()) {
                    log.error((Object)("Bean 'taskExecutor' in META-INF/spring/extender.xml configuration file is not an instance of " + TaskExecutor.class.getName() + ". " + "Using defaults."));
                }
            } else if (log.isWarnEnabled()) {
                log.warn((Object)"Found META-INF/spring/extender.xml configuration file, but no bean named 'taskExecutor' was defined; using defaults.");
            }
        }
        locations = this.monitor;
        synchronized (this.monitor) {
            this.threadGroup = new ThreadGroup("spring-osgi-extender[" + ObjectUtils.getIdentityHexString((Object)this) + "]-threads");
            this.threadGroup.setDaemon(false);
            // ** MonitorExit[locations] (shouldn't be in output)
            SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
            taskExecutor.setThreadGroup(this.threadGroup);
            taskExecutor.setThreadNamePrefix("SpringOsgiExtenderThread-");
            return taskExecutor;
        }
    }

    private class ContextBundleListener
    extends BaseListener {
        private ContextBundleListener() {
        }

        protected void handleEvent(BundleEvent event) {
            Bundle bundle = event.getBundle();
            if (bundle.getBundleId() == ContextLoaderListener.this.bundleId) {
                return;
            }
            switch (event.getType()) {
                case 2: {
                    ContextLoaderListener.this.maybeCreateApplicationContextFor(bundle);
                    break;
                }
                case 256: {
                    if (OsgiBundleUtils.isSystemBundle((Bundle)bundle)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"System bundle stopping");
                        }
                        ContextLoaderListener.this.shutdown();
                        break;
                    }
                    ContextLoaderListener.this.maybeCloseApplicationContextFor(bundle);
                    break;
                }
            }
        }
    }

    private class NamespaceBundleLister
    extends BaseListener {
        private NamespaceBundleLister() {
        }

        protected void handleEvent(BundleEvent event) {
            Bundle bundle = event.getBundle();
            switch (event.getType()) {
                case 32: {
                    ContextLoaderListener.this.maybeAddNamespaceHandlerFor(bundle);
                    break;
                }
                case 64: {
                    ContextLoaderListener.this.maybeRemoveNameSpaceHandlerFor(bundle);
                    break;
                }
            }
        }
    }

    private abstract class BaseListener
    implements SynchronousBundleListener {
        private BaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            boolean trace = log.isTraceEnabled();
            Object object = ContextLoaderListener.this.monitor;
            synchronized (object) {
                if (ContextLoaderListener.this.isClosed) {
                    if (trace) {
                        log.trace((Object)"Listener is closed; events are being ignored");
                    }
                    return;
                }
            }
            if (trace) {
                log.debug((Object)("Processing bundle event [" + OsgiStringUtils.nullSafeToString((BundleEvent)event) + "] for bundle [" + OsgiStringUtils.nullSafeSymbolicName((Bundle)event.getBundle()) + "]"));
            }
            try {
                this.handleEvent(event);
            }
            catch (Exception ex) {
                log.warn((Object)("Got exception while handling event " + event), (Throwable)ex);
            }
        }

        protected abstract void handleEvent(BundleEvent var1);
    }
}

