/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.internal.util.IOUtils;

public abstract class JarUtils {
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dumpJarContent(JarInputStream jis) {
        StringBuffer buffer = new StringBuffer();
        try {
            JarEntry entry;
            while ((entry = jis.getNextJarEntry()) != null) {
                buffer.append(entry.getName());
                buffer.append("\n");
            }
        }
        catch (IOException ioException) {
            buffer.append("reading from stream failed");
        }
        finally {
            IOUtils.closeStream(jis);
        }
        return buffer.toString();
    }

    public static String dumpJarContent(Resource resource) {
        try {
            return JarUtils.dumpJarContent(new JarInputStream(resource.getInputStream()));
        }
        catch (IOException ex) {
            return "reading from stream failed" + ex;
        }
    }

    public static int writeToJar(Resource res, String entryName, JarOutputStream jarStream) throws IOException {
        return JarUtils.writeToJar(res, entryName, jarStream, 1024);
    }

    public static int writeToJar(Resource res, String entryName, JarOutputStream jarStream, int bufferSize) throws IOException {
        int numberOfBytes;
        byte[] readWriteJarBuffer = new byte[bufferSize];
        if (entryName.charAt(0) == '/') {
            entryName = entryName.substring(1);
        }
        jarStream.putNextEntry(new ZipEntry(entryName));
        InputStream entryStream = res.getInputStream();
        while ((numberOfBytes = entryStream.read(readWriteJarBuffer)) != -1) {
            jarStream.write(readWriteJarBuffer, 0, numberOfBytes);
        }
        return numberOfBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static Manifest getManifest(InputStream stream) {
        Manifest manifest;
        JarInputStream myStream = null;
        try {
            myStream = new JarInputStream(stream);
            manifest = myStream.getManifest();
        }
        catch (IOException iOException) {
            IOUtils.closeStream(myStream);
            catch (Throwable throwable) {
                IOUtils.closeStream(myStream);
                throw throwable;
            }
        }
        IOUtils.closeStream(myStream);
        return manifest;
        return null;
    }

    public static Manifest getManifest(Resource resource) {
        try {
            return JarUtils.getManifest(resource.getInputStream());
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

