/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.internal.util;

import java.util.LinkedHashSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.internal.util.JarUtils;
import org.springframework.util.StringUtils;

public abstract class ManifestUtils {
    public static String[] determineImportPackages(Resource[] resources) {
        LinkedHashSet collection = new LinkedHashSet();
        for (int i = 0; i < resources.length; ++i) {
            Attributes attrs;
            String exportedPackages;
            Resource resource = resources[i];
            Manifest man = JarUtils.getManifest(resource);
            if (man == null || !StringUtils.hasText((String)(exportedPackages = (attrs = man.getMainAttributes()).getValue("Export-Package")))) continue;
            collection.addAll(StringUtils.commaDelimitedListToSet((String)exportedPackages));
        }
        String[] array = collection.toArray(new String[collection.size()]);
        for (int i = 0; i < array.length; ++i) {
            array[i] = StringUtils.trimWhitespace((String)array[i]);
        }
        return array;
    }
}

