/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.test.provisioning.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MavenPackagedArtifactFinder {
    private static final String POM_XML = "pom.xml";
    private static final String TARGET = "target";
    private final String artifactName;

    public MavenPackagedArtifactFinder(String artifactId, String version, String type) {
        this.artifactName = artifactId + "-" + version + "." + type;
    }

    File findPackagedArtifact(File startingDirectory) throws IOException {
        if (!this.isMavenProjectDirectory(startingDirectory)) {
            throw new IllegalStateException(startingDirectory + " does not contain a pom.xml file");
        }
        File rootMavenProjectDir = this.findRootMavenProjectDir(startingDirectory.getCanonicalFile());
        File found = this.findInDirectoryTree(this.artifactName, rootMavenProjectDir);
        if (found == null) {
            throw new FileNotFoundException("Cannot find the artifact <" + this.artifactName + ">");
        }
        return found;
    }

    private boolean isMavenProjectDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        return new File(dir, POM_XML).exists();
    }

    private File findRootMavenProjectDir(File dir) {
        File lastFoundMavenProjectDir = dir;
        File parentDir = dir.getParentFile();
        while (this.isMavenProjectDirectory(parentDir)) {
            lastFoundMavenProjectDir = parentDir;
            parentDir = parentDir.getParentFile();
        }
        return lastFoundMavenProjectDir;
    }

    private File findInDirectoryTree(String fileName, File root) {
        File targetDir = new File(root, TARGET);
        if (targetDir.exists() && new File(targetDir, fileName).exists()) {
            return new File(targetDir, fileName);
        }
        File[] children = root.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                if (!MavenPackagedArtifactFinder.this.isMavenProjectDirectory(pathname)) {
                    return false;
                }
                if (pathname.getName().equals(MavenPackagedArtifactFinder.TARGET)) {
                    return false;
                }
                if (pathname.getName().equals("src")) {
                    return false;
                }
                return !pathname.getName().equals(".svn");
            }
        });
        for (int i = 0; i < children.length; ++i) {
            File found = this.findInDirectoryTree(fileName, children[i]);
            if (found == null) continue;
            return found;
        }
        return null;
    }
}

