/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.pulsar.test.support;

import java.util.List;
import java.util.stream.Stream;
import org.apache.pulsar.client.api.Message;
import org.springframework.pulsar.test.support.ConsumedMessagesCondition;
import org.springframework.util.Assert;

public interface ConsumedMessagesConditions {
    public static <T> ConsumedMessagesCondition<T> desiredMessageCount(int messageCount) {
        Assert.state((messageCount > 0 ? 1 : 0) != 0, (String)"Desired message count must be greater than 0");
        return messages -> messages.size() == messageCount;
    }

    public static <T> ConsumedMessagesCondition<T> atLeastOneMessageMatches(T expectation) {
        return messages -> messages.stream().map(Message::getValue).anyMatch(expectation::equals);
    }

    @SafeVarargs
    public static <T> ConsumedMessagesCondition<T> atLeastOneMessageMatchesEachOf(T ... expectation) {
        return messages -> {
            List<Object> values = messages.stream().map(Message::getValue).toList();
            return Stream.of(expectation).allMatch(values::contains);
        };
    }
}

