/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.restdocs.RestDocumentationResultHandler;
import org.springframework.restdocs.response.ResponsePostProcessor;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.util.ReflectionUtils;

public final class ResponseModifier {
    private final List<ResponsePostProcessor> postProcessors;

    ResponseModifier(ResponsePostProcessor ... postProcessors) {
        this.postProcessors = Arrays.asList(postProcessors);
    }

    public RestDocumentationResultHandler andDocument(String outputDir) {
        return new ResponseModifyingRestDocumentationResultHandler(outputDir);
    }

    class ResponseModifyingRestDocumentationResultHandler
    extends RestDocumentationResultHandler {
        public ResponseModifyingRestDocumentationResultHandler(String outputDir) {
            super(outputDir);
        }

        @Override
        public void handle(MvcResult result) throws Exception {
            super.handle(this.postProcessResponse(result));
        }

        MvcResult postProcessResponse(MvcResult result) throws Exception {
            MockHttpServletResponse response = result.getResponse();
            for (ResponsePostProcessor postProcessor : ResponseModifier.this.postProcessors) {
                response = postProcessor.postProcess(response);
            }
            return this.decorateResult(result, response);
        }

        private MvcResult decorateResult(MvcResult result, MockHttpServletResponse response) {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(MvcResult.class);
            enhancer.setCallback((Callback)new GetResponseMethodInterceptor(response, result));
            return (MvcResult)enhancer.create();
        }

        private class GetResponseMethodInterceptor
        implements MethodInterceptor {
            private final MvcResult delegate;
            private final MockHttpServletResponse response;
            private final Method getResponseMethod = this.findMethod("getResponse");

            private GetResponseMethodInterceptor(MockHttpServletResponse response, MvcResult delegate) {
                this.delegate = delegate;
                this.response = response;
            }

            public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws IllegalAccessException, InvocationTargetException {
                if (this.getResponseMethod.equals(method)) {
                    return this.response;
                }
                return method.invoke((Object)this.delegate, args);
            }

            private Method findMethod(String methodName) {
                return BridgeMethodResolver.findBridgedMethod((Method)ReflectionUtils.findMethod(MvcResult.class, (String)methodName));
            }
        }
    }
}

