/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.curl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.snippet.DocumentationWriter;
import org.springframework.restdocs.snippet.SnippetWritingResultHandler;
import org.springframework.restdocs.util.DocumentableHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.util.StringUtils;

public abstract class CurlDocumentation {
    private CurlDocumentation() {
    }

    public static SnippetWritingResultHandler documentCurlRequest(String outputDir) {
        return new SnippetWritingResultHandler(outputDir, "curl-request"){

            @Override
            public void handle(MvcResult result, DocumentationWriter writer) throws IOException {
                writer.shellCommand(new CurlRequestDocumentationAction(writer, result));
            }
        };
    }

    private static final class CurlRequestDocumentationAction
    implements DocumentationWriter.DocumentationAction {
        private static final String SCHEME_HTTP = "http";
        private static final String SCHEME_HTTPS = "https";
        private static final int STANDARD_PORT_HTTP = 80;
        private static final int STANDARD_PORT_HTTPS = 443;
        private final DocumentationWriter writer;
        private final MvcResult result;

        CurlRequestDocumentationAction(DocumentationWriter writer, MvcResult result) {
            this.writer = writer;
            this.result = result;
        }

        @Override
        public void perform() throws IOException {
            DocumentableHttpServletRequest request = new DocumentableHttpServletRequest(this.result.getRequest());
            this.writer.print("curl '");
            this.writeAuthority(request);
            this.writePathAndQueryString(request);
            this.writer.print("'");
            this.writeOptionToIncludeHeadersInOutput();
            this.writeHttpMethodIfNecessary(request);
            this.writeHeaders(request);
            this.writeContent(request);
            this.writer.println();
        }

        private void writeAuthority(DocumentableHttpServletRequest request) {
            this.writer.print(String.format("%s://%s", request.getScheme(), request.getHost()));
            if (this.isNonStandardPort(request)) {
                this.writer.print(String.format(":%d", request.getPort()));
            }
        }

        private boolean isNonStandardPort(DocumentableHttpServletRequest request) {
            return SCHEME_HTTP.equals(request.getScheme()) && request.getPort() != 80 || SCHEME_HTTPS.equals(request.getScheme()) && request.getPort() != 443;
        }

        private void writePathAndQueryString(DocumentableHttpServletRequest request) {
            if (StringUtils.hasText((String)request.getContextPath())) {
                this.writer.print(String.format(request.getContextPath().startsWith("/") ? "%s" : "/%s", request.getContextPath()));
            }
            this.writer.print(request.getRequestUriWithQueryString());
        }

        private void writeOptionToIncludeHeadersInOutput() {
            this.writer.print(" -i");
        }

        private void writeHttpMethodIfNecessary(DocumentableHttpServletRequest request) {
            if (!request.isGetRequest()) {
                this.writer.print(String.format(" -X %s", request.getMethod()));
            }
        }

        private void writeHeaders(DocumentableHttpServletRequest request) {
            for (Map.Entry entry : request.getHeaders().entrySet()) {
                for (String header : (List)entry.getValue()) {
                    this.writer.print(String.format(" -H '%s: %s'", entry.getKey(), header));
                }
            }
        }

        private void writeContent(DocumentableHttpServletRequest request) throws IOException {
            String queryString;
            if (request.getContentLength() > 0L) {
                this.writer.print(String.format(" -d '%s'", request.getContentAsString()));
            } else if ((request.isPostRequest() || request.isPutRequest()) && StringUtils.hasText((String)(queryString = request.getParameterMapAsQueryString()))) {
                this.writer.print(String.format(" -d '%s'", queryString));
            }
        }
    }
}

