/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.restdocs.snippet.DocumentationWriter;
import org.springframework.restdocs.snippet.SnippetWritingResultHandler;
import org.springframework.restdocs.util.DocumentableHttpServletRequest;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.util.StringUtils;

public abstract class HttpDocumentation {
    private HttpDocumentation() {
    }

    public static SnippetWritingResultHandler documentHttpRequest(String outputDir) {
        return new SnippetWritingResultHandler(outputDir, "http-request"){

            @Override
            public void handle(MvcResult result, DocumentationWriter writer) throws IOException {
                writer.codeBlock("http", new HttpRequestDocumentationAction(writer, result));
            }
        };
    }

    public static SnippetWritingResultHandler documentHttpResponse(String outputDir) {
        return new SnippetWritingResultHandler(outputDir, "http-response"){

            @Override
            public void handle(MvcResult result, DocumentationWriter writer) throws IOException {
                writer.codeBlock("http", new HttpResponseDocumentationAction(writer, result));
            }
        };
    }

    private static final class HttpResponseDocumentationAction
    implements DocumentationWriter.DocumentationAction {
        private final DocumentationWriter writer;
        private final MvcResult result;

        HttpResponseDocumentationAction(DocumentationWriter writer, MvcResult result) {
            this.writer = writer;
            this.result = result;
        }

        @Override
        public void perform() throws IOException {
            HttpStatus status = HttpStatus.valueOf((int)this.result.getResponse().getStatus());
            this.writer.println(String.format("HTTP/1.1 %d %s", status.value(), status.getReasonPhrase()));
            for (String headerName : this.result.getResponse().getHeaderNames()) {
                for (String header : this.result.getResponse().getHeaders(headerName)) {
                    this.writer.println(String.format("%s: %s", headerName, header));
                }
            }
            this.writer.println();
            String content = this.result.getResponse().getContentAsString();
            if (StringUtils.hasText((String)content)) {
                this.writer.println(content);
            }
        }
    }

    private static class HttpRequestDocumentationAction
    implements DocumentationWriter.DocumentationAction {
        private final DocumentationWriter writer;
        private final MvcResult result;

        HttpRequestDocumentationAction(DocumentationWriter writer, MvcResult result) {
            this.writer = writer;
            this.result = result;
        }

        @Override
        public void perform() throws IOException {
            String queryString;
            DocumentableHttpServletRequest request = new DocumentableHttpServletRequest(this.result.getRequest());
            this.writer.printf("%s %s HTTP/1.1%n", request.getMethod(), request.getRequestUriWithQueryString());
            for (Map.Entry header : request.getHeaders().entrySet()) {
                for (String value : (List)header.getValue()) {
                    this.writer.printf("%s: %s%n", header.getKey(), value);
                }
            }
            if (this.requiresFormEncodingContentType(request)) {
                this.writer.printf("%s: %s%n", "Content-Type", "application/x-www-form-urlencoded");
            }
            this.writer.println();
            if (request.getContentLength() > 0L) {
                this.writer.println(request.getContentAsString());
            } else if ((request.isPostRequest() || request.isPutRequest()) && StringUtils.hasText((String)(queryString = request.getParameterMapAsQueryString()))) {
                this.writer.println(queryString);
            }
        }

        private boolean requiresFormEncodingContentType(DocumentableHttpServletRequest request) {
            return request.getHeaders().getContentType() == null && (request.isPostRequest() || request.isPutRequest()) && StringUtils.hasText((String)request.getParameterMapAsQueryString());
        }
    }
}

