/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import java.util.Collection;
import java.util.Map;
import org.springframework.restdocs.payload.FieldPath;
import org.springframework.restdocs.payload.FieldProcessor;
import org.springframework.restdocs.payload.FieldType;

class FieldTypeResolver {
    private final FieldProcessor fieldProcessor = new FieldProcessor();

    FieldTypeResolver() {
    }

    FieldType resolveFieldType(String path, Object payload) {
        FieldPath fieldPath = FieldPath.compile(path);
        Object field = this.fieldProcessor.extract(fieldPath, payload);
        if (field instanceof Collection && !fieldPath.isPrecise()) {
            FieldType commonType = null;
            for (Object item : (Collection)field) {
                FieldType fieldType = this.determineFieldType(item);
                if (commonType == null) {
                    commonType = fieldType;
                    continue;
                }
                if (fieldType == commonType) continue;
                return FieldType.VARIES;
            }
            return commonType;
        }
        return this.determineFieldType(this.fieldProcessor.extract(fieldPath, payload));
    }

    private FieldType determineFieldType(Object fieldValue) {
        if (fieldValue == null) {
            return FieldType.NULL;
        }
        if (fieldValue instanceof String) {
            return FieldType.STRING;
        }
        if (fieldValue instanceof Map) {
            return FieldType.OBJECT;
        }
        if (fieldValue instanceof Collection) {
            return FieldType.ARRAY;
        }
        if (fieldValue instanceof Boolean) {
            return FieldType.BOOLEAN;
        }
        return FieldType.NUMBER;
    }
}

