/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.io.IOException;
import java.io.Writer;
import org.springframework.restdocs.snippet.DocumentationWriter;

public class AsciidoctorWriter
extends DocumentationWriter {
    private static final String DELIMITER_CODE_BLOCK = "----";
    private static final String DELIMITER_TABLE = "|===";
    private final DocumentationWriter.TableWriter tableWriter = new AsciidoctorTableWriter();

    public AsciidoctorWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void shellCommand(final DocumentationWriter.DocumentationAction action) throws IOException {
        this.codeBlock("bash", new DocumentationWriter.DocumentationAction(){

            @Override
            public void perform() throws IOException {
                AsciidoctorWriter.this.print("$ ");
                action.perform();
            }
        });
    }

    @Override
    public void codeBlock(String language, DocumentationWriter.DocumentationAction action) throws IOException {
        this.println();
        if (language != null) {
            this.println("[source," + language + "]");
        }
        this.println(DELIMITER_CODE_BLOCK);
        action.perform();
        this.println(DELIMITER_CODE_BLOCK);
        this.println();
    }

    @Override
    public void table(DocumentationWriter.TableAction action) throws IOException {
        this.println();
        this.println(DELIMITER_TABLE);
        action.perform(this.tableWriter);
        this.println(DELIMITER_TABLE);
        this.println();
    }

    private final class AsciidoctorTableWriter
    implements DocumentationWriter.TableWriter {
        private AsciidoctorTableWriter() {
        }

        @Override
        public void headers(String ... headers) {
            StringBuilder builder = new StringBuilder();
            for (String header : headers) {
                builder.append("|");
                builder.append(header);
            }
            AsciidoctorWriter.this.println(builder.toString());
            AsciidoctorWriter.this.println();
        }

        @Override
        public void row(String ... entries) {
            for (String entry : entries) {
                AsciidoctorWriter.this.print("|");
                AsciidoctorWriter.this.println(entry);
            }
            AsciidoctorWriter.this.println();
        }
    }
}

