/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.snippet;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.restdocs.config.RestDocumentationContext;
import org.springframework.restdocs.snippet.DocumentationProperties;

class OutputFileResolver {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([A-Z])");

    OutputFileResolver() {
    }

    File resolve(String outputDirectory, String fileName) {
        Map<String, String> replacements = this.createReplacements();
        String path = outputDirectory;
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            while (path.contains(replacement.getKey())) {
                if (replacement.getValue() == null) {
                    throw new IllegalStateException("No replacement is available for " + replacement.getKey());
                }
                path = path.replace(replacement.getKey(), replacement.getValue());
            }
        }
        File outputFile = new File(path, fileName);
        if (!outputFile.isAbsolute()) {
            outputFile = this.makeRelativeToConfiguredOutputDir(outputFile);
        }
        return outputFile;
    }

    private Map<String, String> createReplacements() {
        RestDocumentationContext context = RestDocumentationContext.currentContext();
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("{methodName}", context == null ? null : context.getTestMethod().getName());
        replacements.put("{method-name}", context == null ? null : this.camelCaseToDash(context.getTestMethod().getName()));
        replacements.put("{method_name}", context == null ? null : this.camelCaseToUnderscore(context.getTestMethod().getName()));
        replacements.put("{step}", context == null ? null : Integer.toString(context.getStepCount()));
        return replacements;
    }

    private String camelCaseToDash(String string) {
        return this.camelCaseToSeparator(string, "-");
    }

    private String camelCaseToUnderscore(String string) {
        return this.camelCaseToSeparator(string, "_");
    }

    private String camelCaseToSeparator(String string, String separator) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(string);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, separator + matcher.group(1).toLowerCase());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private File makeRelativeToConfiguredOutputDir(File outputFile) {
        File configuredOutputDir = new DocumentationProperties().getOutputDir();
        if (configuredOutputDir != null) {
            return new File(configuredOutputDir, outputFile.getPath());
        }
        return null;
    }
}

