/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scala.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class ScalaBeanInfo
implements BeanInfo {
    private static final Log logger = LogFactory.getLog(ScalaBeanInfo.class);
    private static final String SCALA_SETTER_SUFFIX = "_$eq";
    private final BeanInfo delegate;
    private final PropertyDescriptor[] propertyDescriptors;

    public ScalaBeanInfo(Class<?> beanClass) throws IntrospectionException {
        this(Introspector.getBeanInfo(beanClass));
    }

    public ScalaBeanInfo(BeanInfo delegate) throws IntrospectionException {
        Assert.notNull((Object)delegate, (String)"'delegate' must not be null");
        this.delegate = delegate;
        this.propertyDescriptors = ScalaBeanInfo.initPropertyDescriptors(delegate);
    }

    private static PropertyDescriptor[] initPropertyDescriptors(BeanInfo beanInfo) {
        TreeMap<String, PropertyDescriptor> propertyDescriptors = new TreeMap<String, PropertyDescriptor>(new PropertyNameComparator());
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
        }
        for (FeatureDescriptor featureDescriptor : beanInfo.getMethodDescriptors()) {
            Method method = ((MethodDescriptor)featureDescriptor).getMethod();
            if (ReflectionUtils.isObjectMethod((Method)method)) continue;
            if (ScalaBeanInfo.isScalaSetter(method)) {
                ScalaBeanInfo.addScalaSetter(propertyDescriptors, method);
                continue;
            }
            if (!ScalaBeanInfo.isScalaGetter(method)) continue;
            ScalaBeanInfo.addScalaGetter(propertyDescriptors, method);
        }
        return propertyDescriptors.values().toArray(new PropertyDescriptor[propertyDescriptors.size()]);
    }

    private static boolean isScalaGetter(Method method) {
        return method.getParameterTypes().length == 0 && !method.getReturnType().equals(Void.TYPE) && !method.getName().startsWith("get") && !method.getName().startsWith("is");
    }

    public static boolean isScalaSetter(Method method) {
        return method.getParameterTypes().length == 1 && method.getReturnType().equals(Void.TYPE) && method.getName().endsWith(SCALA_SETTER_SUFFIX);
    }

    private static void addScalaSetter(Map<String, PropertyDescriptor> propertyDescriptors, Method writeMethod) {
        String propertyName = writeMethod.getName().substring(0, writeMethod.getName().length() - SCALA_SETTER_SUFFIX.length());
        PropertyDescriptor pd = propertyDescriptors.get(propertyName);
        if (pd != null && pd.getWriteMethod() == null) {
            try {
                pd.setWriteMethod(writeMethod);
            }
            catch (IntrospectionException ex) {
                logger.debug((Object)("Could not add write method [" + writeMethod + "] for " + "property [" + propertyName + "]: " + ex.getMessage()));
            }
        } else if (pd == null) {
            try {
                pd = new PropertyDescriptor(propertyName, null, writeMethod);
                propertyDescriptors.put(propertyName, pd);
            }
            catch (IntrospectionException ex) {
                logger.debug((Object)("Could not create new PropertyDescriptor for writeMethod [" + writeMethod + "] property [" + propertyName + "]: " + ex.getMessage()));
            }
        }
    }

    private static void addScalaGetter(Map<String, PropertyDescriptor> propertyDescriptors, Method readMethod) {
        String propertyName = readMethod.getName();
        PropertyDescriptor pd = propertyDescriptors.get(propertyName);
        if (pd != null && pd.getReadMethod() == null) {
            try {
                pd.setReadMethod(readMethod);
            }
            catch (IntrospectionException ex) {
                logger.debug((Object)("Could not add read method [" + readMethod + "] for " + "property [" + propertyName + "]: " + ex.getMessage()));
            }
        } else if (pd == null) {
            try {
                pd = new PropertyDescriptor(propertyName, readMethod, null);
                propertyDescriptors.put(propertyName, pd);
            }
            catch (IntrospectionException ex) {
                logger.debug((Object)("Could not create new PropertyDescriptor for readMethod [" + readMethod + "] property [" + propertyName + "]: " + ex.getMessage()));
            }
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return this.delegate.getAdditionalBeanInfo();
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.delegate.getBeanDescriptor();
    }

    @Override
    public int getDefaultEventIndex() {
        return this.delegate.getDefaultEventIndex();
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.delegate.getDefaultPropertyIndex();
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.delegate.getEventSetDescriptors();
    }

    @Override
    public Image getIcon(int iconKind) {
        return this.delegate.getIcon(iconKind);
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.delegate.getMethodDescriptors();
    }

    private static class PropertyNameComparator
    implements Comparator<String> {
        private PropertyNameComparator() {
        }

        @Override
        public int compare(String left, String right) {
            byte[] leftBytes = left.getBytes();
            byte[] rightBytes = right.getBytes();
            for (int i = 0; i < left.length(); ++i) {
                if (right.length() == i) {
                    return 1;
                }
                int result = leftBytes[i] - rightBytes[i];
                if (result == 0) continue;
                return result;
            }
            return left.length() - right.length();
        }
    }
}

