/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.jdbc;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.util.Assert;

class AclClassIdUtils {
    private static final String DEFAULT_CLASS_ID_TYPE_COLUMN_NAME = "class_id_type";
    private static final Log log = LogFactory.getLog(AclClassIdUtils.class);
    private ConversionService conversionService;

    AclClassIdUtils() {
        GenericConversionService genericConversionService = new GenericConversionService();
        genericConversionService.addConverter(String.class, Long.class, (Converter)new StringToLongConverter());
        genericConversionService.addConverter(String.class, UUID.class, (Converter)new StringToUUIDConverter());
        this.conversionService = genericConversionService;
    }

    AclClassIdUtils(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
    }

    Serializable identifierFrom(Serializable identifier, ResultSet resultSet) throws SQLException {
        identifier = this.isString(identifier) && this.hasValidClassIdType(resultSet) && this.canConvertFromStringTo(this.classIdTypeFrom(resultSet)) ? this.convertFromStringTo((String)((Object)identifier), this.classIdTypeFrom(resultSet)) : this.convertToLong(identifier);
        return identifier;
    }

    private boolean hasValidClassIdType(ResultSet resultSet) throws SQLException {
        boolean hasClassIdType = false;
        try {
            hasClassIdType = this.classIdTypeFrom(resultSet) != null;
        }
        catch (SQLException e) {
            log.debug((Object)"Unable to obtain the class id type", (Throwable)e);
        }
        return hasClassIdType;
    }

    private <T extends Serializable> Class<T> classIdTypeFrom(ResultSet resultSet) throws SQLException {
        return this.classIdTypeFrom(resultSet.getString(DEFAULT_CLASS_ID_TYPE_COLUMN_NAME));
    }

    private <T extends Serializable> Class<T> classIdTypeFrom(String className) {
        Class<?> targetType = null;
        if (className != null) {
            try {
                targetType = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                log.debug((Object)"Unable to find class id type on classpath", (Throwable)e);
            }
        }
        return targetType;
    }

    private <T> boolean canConvertFromStringTo(Class<T> targetType) {
        return this.conversionService.canConvert(String.class, targetType);
    }

    private <T extends Serializable> T convertFromStringTo(String identifier, Class<T> targetType) {
        return (T)((Serializable)this.conversionService.convert((Object)identifier, targetType));
    }

    private Long convertToLong(Serializable identifier) {
        Long idAsLong = this.canConvertFromStringTo(Long.class) ? (Long)this.conversionService.convert((Object)identifier, Long.class) : Long.valueOf(identifier.toString());
        return idAsLong;
    }

    private boolean isString(Serializable object) {
        return object.getClass().isAssignableFrom(String.class);
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.conversionService = conversionService;
    }

    private static class StringToUUIDConverter
    implements Converter<String, UUID> {
        private StringToUUIDConverter() {
        }

        public UUID convert(String identifierAsString) {
            if (identifierAsString == null) {
                throw new ConversionFailedException(TypeDescriptor.valueOf(String.class), TypeDescriptor.valueOf(UUID.class), null, null);
            }
            return UUID.fromString(identifierAsString);
        }
    }

    private static class StringToLongConverter
    implements Converter<String, Long> {
        private StringToLongConverter() {
        }

        public Long convert(String identifierAsString) {
            if (identifierAsString == null) {
                throw new ConversionFailedException(TypeDescriptor.valueOf(String.class), TypeDescriptor.valueOf(Long.class), null, null);
            }
            return Long.parseLong(identifierAsString);
        }
    }
}

