/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.debug;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.config.debug.DebugRequestWrapper;
import org.springframework.security.config.debug.Logger;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.util.RequestMatcher;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DebugFilter
extends OncePerRequestFilter {
    private final FilterChainProxy fcp;
    private final Map<RequestMatcher, List<Filter>> filterChainMap;

    public DebugFilter(FilterChainProxy fcp) {
        this.fcp = fcp;
        this.filterChainMap = fcp.getFilterChainMap();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        List<Filter> filters = this.getFilters(request);
        Logger.log("Request received for '" + UrlUtils.buildRequestUrl((HttpServletRequest)request) + "':\n\n" + request + "\n\n" + this.formatFilters(filters));
        this.fcp.doFilter((ServletRequest)new DebugRequestWrapper(request), (ServletResponse)response, filterChain);
    }

    String formatFilters(List<Filter> filters) {
        StringBuilder sb = new StringBuilder();
        sb.append("Security filter chain: ");
        if (filters == null) {
            sb.append("no match");
        } else if (filters.isEmpty()) {
            sb.append("[] empty (bypassed by security='none') ");
        } else {
            sb.append("[\n");
            for (Filter f : filters) {
                sb.append("  ").append(f.getClass().getSimpleName()).append("\n");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    private List<Filter> getFilters(HttpServletRequest request) {
        for (Map.Entry<RequestMatcher, List<Filter>> entry : this.filterChainMap.entrySet()) {
            RequestMatcher matcher = entry.getKey();
            if (!matcher.matches(request)) continue;
            return entry.getValue();
        }
        return null;
    }
}

