/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configuration;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class WebSecurityConfiguration
implements ImportAware,
BeanClassLoaderAware {
    private WebSecurity webSecurity;
    private Boolean debugEnabled;
    private List<SecurityConfigurer<Filter, WebSecurity>> webSecurityConfigurers;
    private ClassLoader beanClassLoader;

    @Bean
    @DependsOn(value={"springSecurityFilterChain"})
    public SecurityExpressionHandler<FilterInvocation> webSecurityExpressionHandler() {
        return this.webSecurity.getExpressionHandler();
    }

    @Bean(name={"springSecurityFilterChain"})
    public Filter springSecurityFilterChain() throws Exception {
        boolean hasConfigurers;
        boolean bl = hasConfigurers = this.webSecurityConfigurers != null && !this.webSecurityConfigurers.isEmpty();
        if (!hasConfigurers) {
            throw new IllegalStateException("At least one non-null instance of " + WebSecurityConfigurer.class.getSimpleName() + " must be exposed as a @Bean when using @EnableWebSecurity. Hint try extending " + WebSecurityConfigurerAdapter.class.getSimpleName());
        }
        return (Filter)this.webSecurity.build();
    }

    @Bean
    @DependsOn(value={"springSecurityFilterChain"})
    public WebInvocationPrivilegeEvaluator privilegeEvaluator() throws Exception {
        return this.webSecurity.getPrivilegeEvaluator();
    }

    @Autowired(required=false)
    public void setFilterChainProxySecurityConfigurer(ObjectPostProcessor<Object> objectPostProcessor, List<SecurityConfigurer<Filter, WebSecurity>> webSecurityConfigurers) throws Exception {
        this.webSecurity = objectPostProcessor.postProcess(new WebSecurity(objectPostProcessor));
        if (this.debugEnabled != null) {
            this.webSecurity.debug(this.debugEnabled);
        }
        Collections.sort(webSecurityConfigurers, AnnotationAwareOrderComparator.INSTANCE);
        Integer previousOrder = null;
        for (SecurityConfigurer<Filter, WebSecurity> config : webSecurityConfigurers) {
            Integer order = AnnotationAwareOrderComparator.lookupOrder(config);
            if (previousOrder != null && previousOrder.equals(order)) {
                throw new IllegalStateException("@Order on WebSecurityConfigurers must be unique. Order of " + order + " was already used, so it cannot be used on " + config + " too.");
            }
            previousOrder = order;
        }
        for (SecurityConfigurer<Filter, WebSecurity> webSecurityConfigurer : webSecurityConfigurers) {
            this.webSecurity.apply(webSecurityConfigurer);
        }
        this.webSecurityConfigurers = webSecurityConfigurers;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map enableWebSecurityAttrMap = importMetadata.getAnnotationAttributes(EnableWebSecurity.class.getName());
        AnnotationAttributes enableWebSecurityAttrs = AnnotationAttributes.fromMap((Map)enableWebSecurityAttrMap);
        if (enableWebSecurityAttrs == null) {
            Class currentClass;
            for (Class classToInspect = currentClass = ClassUtils.resolveClassName((String)importMetadata.getClassName(), (ClassLoader)this.beanClassLoader); classToInspect != null; classToInspect = classToInspect.getSuperclass()) {
                EnableWebSecurity enableWebSecurityAnnotation = (EnableWebSecurity)AnnotationUtils.findAnnotation((Class)classToInspect, EnableWebSecurity.class);
                if (enableWebSecurityAnnotation == null) continue;
                enableWebSecurityAttrMap = AnnotationUtils.getAnnotationAttributes((Annotation)enableWebSecurityAnnotation);
                enableWebSecurityAttrs = AnnotationAttributes.fromMap((Map)enableWebSecurityAttrMap);
            }
        }
        this.debugEnabled = enableWebSecurityAttrs.getBoolean("debug");
        if (this.webSecurity != null) {
            this.webSecurity.debug(this.debugEnabled);
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    private static class AnnotationAwareOrderComparator
    extends OrderComparator {
        private static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

        private AnnotationAwareOrderComparator() {
        }

        protected int getOrder(Object obj) {
            return AnnotationAwareOrderComparator.lookupOrder(obj);
        }

        private static int lookupOrder(Object obj) {
            Class<?> clazz;
            Order order;
            if (obj instanceof Ordered) {
                return ((Ordered)obj).getOrder();
            }
            if (obj != null && (order = (Order)AnnotationUtils.findAnnotation(clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass(), Order.class)) != null) {
                return order.value();
            }
            return Integer.MAX_VALUE;
        }
    }
}

