/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.method.configuration;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.context.annotation.Role;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.access.annotation.Jsr250MethodSecurityMetadataSource;
import org.springframework.security.access.annotation.Jsr250Voter;
import org.springframework.security.access.annotation.SecuredAnnotationSecurityMetadataSource;
import org.springframework.security.access.expression.method.DefaultMethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.ExpressionBasedAnnotationAttributeFactory;
import org.springframework.security.access.expression.method.ExpressionBasedPostInvocationAdvice;
import org.springframework.security.access.expression.method.ExpressionBasedPreInvocationAdvice;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.intercept.AfterInvocationManager;
import org.springframework.security.access.intercept.AfterInvocationProviderManager;
import org.springframework.security.access.intercept.RunAsManager;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor;
import org.springframework.security.access.intercept.aopalliance.MethodSecurityMetadataSourceAdvisor;
import org.springframework.security.access.method.DelegatingMethodSecurityMetadataSource;
import org.springframework.security.access.method.MethodSecurityMetadataSource;
import org.springframework.security.access.prepost.PostInvocationAdviceProvider;
import org.springframework.security.access.prepost.PostInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdvice;
import org.springframework.security.access.prepost.PreInvocationAuthorizationAdviceVoter;
import org.springframework.security.access.prepost.PrePostAnnotationSecurityMetadataSource;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class GlobalMethodSecurityConfiguration
implements ImportAware {
    private static final Log logger = LogFactory.getLog(GlobalMethodSecurityConfiguration.class);
    private ApplicationContext context;
    private ObjectPostProcessor<Object> objectPostProcessor = new ObjectPostProcessor<Object>(){

        @Override
        public <T> T postProcess(T object) {
            throw new IllegalStateException(ObjectPostProcessor.class.getName() + " is a required bean. Ensure you have used @" + EnableGlobalMethodSecurity.class.getName());
        }
    };
    private DefaultMethodSecurityExpressionHandler defaultMethodExpressionHandler = new DefaultMethodSecurityExpressionHandler();
    private AuthenticationManager authenticationManager;
    private AuthenticationManagerBuilder auth;
    private boolean disableAuthenticationRegistry;
    private AnnotationAttributes enableMethodSecurity;
    private MethodSecurityExpressionHandler expressionHandler;

    @Bean
    public MethodInterceptor methodSecurityInterceptor() throws Exception {
        MethodSecurityInterceptor methodSecurityInterceptor = new MethodSecurityInterceptor();
        methodSecurityInterceptor.setAccessDecisionManager(this.accessDecisionManager());
        methodSecurityInterceptor.setAfterInvocationManager(this.afterInvocationManager());
        methodSecurityInterceptor.setAuthenticationManager(this.authenticationManager());
        methodSecurityInterceptor.setSecurityMetadataSource(this.methodSecurityMetadataSource());
        RunAsManager runAsManager = this.runAsManager();
        if (runAsManager != null) {
            methodSecurityInterceptor.setRunAsManager(runAsManager);
        }
        return methodSecurityInterceptor;
    }

    protected AfterInvocationManager afterInvocationManager() {
        if (this.prePostEnabled()) {
            AfterInvocationProviderManager invocationProviderManager = new AfterInvocationProviderManager();
            ExpressionBasedPostInvocationAdvice postAdvice = new ExpressionBasedPostInvocationAdvice(this.getExpressionHandler());
            PostInvocationAdviceProvider postInvocationAdviceProvider = new PostInvocationAdviceProvider((PostInvocationAuthorizationAdvice)postAdvice);
            ArrayList<PostInvocationAdviceProvider> afterInvocationProviders = new ArrayList<PostInvocationAdviceProvider>();
            afterInvocationProviders.add(postInvocationAdviceProvider);
            invocationProviderManager.setProviders(afterInvocationProviders);
            return invocationProviderManager;
        }
        return null;
    }

    protected RunAsManager runAsManager() {
        return null;
    }

    protected AccessDecisionManager accessDecisionManager() {
        ArrayList<Object> decisionVoters = new ArrayList<Object>();
        ExpressionBasedPreInvocationAdvice expressionAdvice = new ExpressionBasedPreInvocationAdvice();
        expressionAdvice.setExpressionHandler(this.getExpressionHandler());
        if (this.prePostEnabled()) {
            decisionVoters.add(new PreInvocationAuthorizationAdviceVoter((PreInvocationAuthorizationAdvice)expressionAdvice));
        }
        if (this.jsr250Enabled()) {
            decisionVoters.add(new Jsr250Voter());
        }
        decisionVoters.add(new RoleVoter());
        decisionVoters.add(new AuthenticatedVoter());
        return new AffirmativeBased(decisionVoters);
    }

    protected MethodSecurityExpressionHandler createExpressionHandler() {
        return this.defaultMethodExpressionHandler;
    }

    protected final MethodSecurityExpressionHandler getExpressionHandler() {
        if (this.expressionHandler == null) {
            this.expressionHandler = this.createExpressionHandler();
        }
        return this.expressionHandler;
    }

    protected MethodSecurityMetadataSource customMethodSecurityMetadataSource() {
        return null;
    }

    protected AuthenticationManager authenticationManager() throws Exception {
        if (this.authenticationManager == null) {
            DefaultAuthenticationEventPublisher eventPublisher = this.objectPostProcessor.postProcess(new DefaultAuthenticationEventPublisher());
            this.auth = new AuthenticationManagerBuilder(this.objectPostProcessor);
            this.auth.authenticationEventPublisher((AuthenticationEventPublisher)eventPublisher);
            this.configure(this.auth);
            if (!this.disableAuthenticationRegistry) {
                this.authenticationManager = (AuthenticationManager)this.auth.build();
            }
            if (this.authenticationManager == null) {
                try {
                    this.authenticationManager = (AuthenticationManager)((AuthenticationManagerBuilder)this.context.getBean(AuthenticationManagerBuilder.class)).getOrBuild();
                }
                catch (NoSuchBeanDefinitionException e) {
                    logger.debug((Object)"Could not obtain the AuthenticationManagerBuilder. This is ok for now, we will try using an AuthenticationManager directly", (Throwable)e);
                }
            }
            if (this.authenticationManager == null) {
                this.authenticationManager = this.lazyBean(AuthenticationManager.class);
            }
        }
        return this.authenticationManager;
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        this.disableAuthenticationRegistry = true;
    }

    @Bean
    public MethodSecurityMetadataSource methodSecurityMetadataSource() {
        ArrayList<Object> sources = new ArrayList<Object>();
        ExpressionBasedAnnotationAttributeFactory attributeFactory = new ExpressionBasedAnnotationAttributeFactory(this.getExpressionHandler());
        MethodSecurityMetadataSource customMethodSecurityMetadataSource = this.customMethodSecurityMetadataSource();
        if (customMethodSecurityMetadataSource != null) {
            sources.add(customMethodSecurityMetadataSource);
        }
        if (this.prePostEnabled()) {
            sources.add(new PrePostAnnotationSecurityMetadataSource((PrePostInvocationAttributeFactory)attributeFactory));
        }
        if (this.securedEnabled()) {
            sources.add(new SecuredAnnotationSecurityMetadataSource());
        }
        if (this.jsr250Enabled()) {
            sources.add(new Jsr250MethodSecurityMetadataSource());
        }
        return new DelegatingMethodSecurityMetadataSource(sources);
    }

    @Bean
    public PreInvocationAuthorizationAdvice preInvocationAuthorizationAdvice() {
        ExpressionBasedPreInvocationAdvice preInvocationAdvice = new ExpressionBasedPreInvocationAdvice();
        preInvocationAdvice.setExpressionHandler(this.getExpressionHandler());
        return preInvocationAdvice;
    }

    @Role(value=2)
    @Bean
    public MethodSecurityMetadataSourceAdvisor metaDataSourceAdvisor() {
        MethodSecurityMetadataSourceAdvisor methodAdvisor = new MethodSecurityMetadataSourceAdvisor("methodSecurityInterceptor", this.methodSecurityMetadataSource(), "methodSecurityMetadataSource");
        methodAdvisor.setOrder(this.order());
        return methodAdvisor;
    }

    public final void setImportMetadata(AnnotationMetadata importMetadata) {
        Map annotationAttributes = importMetadata.getAnnotationAttributes(EnableGlobalMethodSecurity.class.getName());
        this.enableMethodSecurity = AnnotationAttributes.fromMap((Map)annotationAttributes);
    }

    @Autowired(required=false)
    public void setAuthenticationTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.defaultMethodExpressionHandler.setTrustResolver(trustResolver);
    }

    @Autowired
    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    @Autowired(required=false)
    public void setObjectPostProcessor(ObjectPostProcessor<Object> objectPostProcessor) {
        this.objectPostProcessor = objectPostProcessor;
        this.defaultMethodExpressionHandler = objectPostProcessor.postProcess(this.defaultMethodExpressionHandler);
    }

    @Autowired(required=false)
    public void setPermissionEvaluator(List<PermissionEvaluator> permissionEvaluators) {
        if (permissionEvaluators.size() != 1) {
            logger.debug((Object)("Not autwiring PermissionEvaluator since size != 1. Got " + permissionEvaluators));
        }
        this.defaultMethodExpressionHandler.setPermissionEvaluator(permissionEvaluators.get(0));
    }

    private <T> T lazyBean(Class<T> interfaceName) {
        LazyInitTargetSource lazyTargetSource = new LazyInitTargetSource();
        String[] beanNamesForType = this.context.getBeanNamesForType(interfaceName);
        Assert.isTrue((beanNamesForType.length == 1 ? 1 : 0) != 0, (String)("Expecting to only find a single bean for type " + interfaceName + ", but found " + Arrays.asList(beanNamesForType)));
        lazyTargetSource.setTargetBeanName(beanNamesForType[0]);
        lazyTargetSource.setBeanFactory((BeanFactory)this.context);
        ProxyFactoryBean proxyFactory = new ProxyFactoryBean();
        proxyFactory.setTargetSource((TargetSource)lazyTargetSource);
        proxyFactory.setInterfaces(new Class[]{interfaceName});
        return (T)proxyFactory.getObject();
    }

    private boolean prePostEnabled() {
        return this.enableMethodSecurity().getBoolean("prePostEnabled");
    }

    private boolean securedEnabled() {
        return this.enableMethodSecurity().getBoolean("securedEnabled");
    }

    private boolean jsr250Enabled() {
        return this.enableMethodSecurity().getBoolean("jsr250Enabled");
    }

    private int order() {
        return (Integer)this.enableMethodSecurity().get((Object)"order");
    }

    private AnnotationAttributes enableMethodSecurity() {
        if (this.enableMethodSecurity == null) {
            EnableGlobalMethodSecurity methodSecurityAnnotation = (EnableGlobalMethodSecurity)AnnotationUtils.findAnnotation(this.getClass(), EnableGlobalMethodSecurity.class);
            Assert.notNull((Object)methodSecurityAnnotation, (String)(EnableGlobalMethodSecurity.class.getName() + " is required"));
            Map methodSecurityAttrs = AnnotationUtils.getAnnotationAttributes((Annotation)methodSecurityAnnotation);
            this.enableMethodSecurity = AnnotationAttributes.fromMap((Map)methodSecurityAttrs);
        }
        return this.enableMethodSecurity;
    }
}

