/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.jwt.nimbus.NimbusJwtDecoderJwkSupport;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.authentication.jwt.DefaultProviderJwtDecoderRegistry;
import org.springframework.security.oauth2.client.authentication.jwt.ProviderJwtDecoderRegistry;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.token.InMemoryAccessTokenRepository;
import org.springframework.security.oauth2.client.token.SecurityTokenRepository;
import org.springframework.security.oauth2.client.user.OAuth2UserService;
import org.springframework.security.oauth2.client.user.web.nimbus.NimbusOAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthorizationCodeAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.web.AuthorizationGrantTokenExchanger;
import org.springframework.security.oauth2.client.web.nimbus.NimbusAuthorizationCodeTokenExchanger;
import org.springframework.security.oauth2.core.AccessToken;
import org.springframework.security.oauth2.core.provider.DefaultProviderMetadata;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestVariablesExtractor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

final class AuthorizationCodeAuthenticationFilterConfigurer<H extends HttpSecurityBuilder<H>, R extends RequestMatcher & RequestVariablesExtractor>
extends AbstractAuthenticationFilterConfigurer<H, AuthorizationCodeAuthenticationFilterConfigurer<H, R>, AuthorizationCodeAuthenticationProcessingFilter> {
    private R authorizationResponseMatcher;
    private AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger;
    private SecurityTokenRepository<AccessToken> accessTokenRepository;
    private OAuth2UserService userInfoService;
    private Map<URI, Class<? extends OAuth2User>> customUserTypes = new HashMap<URI, Class<? extends OAuth2User>>();
    private Map<URI, String> userNameAttributeNames = new HashMap<URI, String>();
    private GrantedAuthoritiesMapper userAuthoritiesMapper;

    AuthorizationCodeAuthenticationFilterConfigurer() {
        super(new AuthorizationCodeAuthenticationProcessingFilter(), null);
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> authorizationResponseMatcher(R authorizationResponseMatcher) {
        Assert.notNull(authorizationResponseMatcher, (String)"authorizationResponseMatcher cannot be null");
        this.authorizationResponseMatcher = authorizationResponseMatcher;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> authorizationCodeTokenExchanger(AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger) {
        Assert.notNull(authorizationCodeTokenExchanger, (String)"authorizationCodeTokenExchanger cannot be null");
        this.authorizationCodeTokenExchanger = authorizationCodeTokenExchanger;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> accessTokenRepository(SecurityTokenRepository<AccessToken> accessTokenRepository) {
        Assert.notNull(accessTokenRepository, (String)"accessTokenRepository cannot be null");
        this.accessTokenRepository = accessTokenRepository;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> userInfoService(OAuth2UserService userInfoService) {
        Assert.notNull((Object)userInfoService, (String)"userInfoService cannot be null");
        this.userInfoService = userInfoService;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> customUserType(Class<? extends OAuth2User> customUserType, URI userInfoUri) {
        Assert.notNull(customUserType, (String)"customUserType cannot be null");
        Assert.notNull((Object)userInfoUri, (String)"userInfoUri cannot be null");
        this.customUserTypes.put(userInfoUri, customUserType);
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> userNameAttributeName(String userNameAttributeName, URI userInfoUri) {
        Assert.hasText((String)userNameAttributeName, (String)"userNameAttributeName cannot be empty");
        Assert.notNull((Object)userInfoUri, (String)"userInfoUri cannot be null");
        this.userNameAttributeNames.put(userInfoUri, userNameAttributeName);
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> userAuthoritiesMapper(GrantedAuthoritiesMapper userAuthoritiesMapper) {
        Assert.notNull((Object)userAuthoritiesMapper, (String)"userAuthoritiesMapper cannot be null");
        this.userAuthoritiesMapper = userAuthoritiesMapper;
        return this;
    }

    AuthorizationCodeAuthenticationFilterConfigurer<H, R> clientRegistrationRepository(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notEmpty((Collection)clientRegistrationRepository.getRegistrations(), (String)"clientRegistrationRepository cannot be empty");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    String getLoginUrl() {
        return super.getLoginPage();
    }

    String getLoginFailureUrl() {
        return super.getFailureUrl();
    }

    @Override
    public void init(H http) throws Exception {
        AuthorizationCodeAuthenticationProvider authenticationProvider = new AuthorizationCodeAuthenticationProvider(this.getAuthorizationCodeTokenExchanger(), this.getAccessTokenRepository(), this.getProviderJwtDecoderRegistry(), this.getUserInfoService());
        if (this.userAuthoritiesMapper != null) {
            authenticationProvider.setAuthoritiesMapper(this.userAuthoritiesMapper);
        }
        authenticationProvider = this.postProcess(authenticationProvider);
        http.authenticationProvider((AuthenticationProvider)authenticationProvider);
        super.init(http);
    }

    @Override
    public void configure(H http) throws Exception {
        AuthorizationCodeAuthenticationProcessingFilter authFilter = (AuthorizationCodeAuthenticationProcessingFilter)this.getAuthenticationFilter();
        if (this.authorizationResponseMatcher != null) {
            authFilter.setAuthorizationResponseMatcher(this.authorizationResponseMatcher);
        }
        authFilter.setClientRegistrationRepository(OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder()));
        super.configure(http);
    }

    @Override
    protected RequestMatcher createLoginProcessingUrlMatcher(String loginProcessingUrl) {
        return this.authorizationResponseMatcher != null ? this.authorizationResponseMatcher : ((AuthorizationCodeAuthenticationProcessingFilter)this.getAuthenticationFilter()).getAuthorizationResponseMatcher();
    }

    private AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> getAuthorizationCodeTokenExchanger() {
        if (this.authorizationCodeTokenExchanger == null) {
            this.authorizationCodeTokenExchanger = new NimbusAuthorizationCodeTokenExchanger();
        }
        return this.authorizationCodeTokenExchanger;
    }

    private SecurityTokenRepository<AccessToken> getAccessTokenRepository() {
        if (this.accessTokenRepository == null) {
            this.accessTokenRepository = new InMemoryAccessTokenRepository();
        }
        return this.accessTokenRepository;
    }

    private ProviderJwtDecoderRegistry getProviderJwtDecoderRegistry() {
        HashMap jwtDecoders = new HashMap();
        ClientRegistrationRepository clientRegistrationRepository = OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder());
        clientRegistrationRepository.getRegistrations().forEach(registration -> {
            ClientRegistration.ProviderDetails providerDetails = registration.getProviderDetails();
            if (StringUtils.hasText((String)providerDetails.getJwkSetUri())) {
                DefaultProviderMetadata providerMetadata = new DefaultProviderMetadata();
                providerMetadata.setIssuer(this.toURL(UriComponentsBuilder.fromHttpUrl((String)providerDetails.getAuthorizationUri()).replacePath(null).toUriString()));
                providerMetadata.setAuthorizationEndpoint(this.toURL(providerDetails.getAuthorizationUri()));
                providerMetadata.setTokenEndpoint(this.toURL(providerDetails.getTokenUri()));
                providerMetadata.setUserInfoEndpoint(this.toURL(providerDetails.getUserInfoUri()));
                providerMetadata.setJwkSetUri(this.toURL(providerDetails.getJwkSetUri()));
                NimbusJwtDecoderJwkSupport nimbusJwtDecoderJwkSupport = new NimbusJwtDecoderJwkSupport(providerDetails.getJwkSetUri());
                jwtDecoders.put(providerMetadata, nimbusJwtDecoderJwkSupport);
            }
        });
        return new DefaultProviderJwtDecoderRegistry(jwtDecoders);
    }

    private OAuth2UserService getUserInfoService() {
        if (this.userInfoService == null) {
            NimbusOAuth2UserService nimbusOAuth2UserService = new NimbusOAuth2UserService();
            if (!this.customUserTypes.isEmpty()) {
                nimbusOAuth2UserService.setCustomUserTypes(this.customUserTypes);
            }
            if (!this.userNameAttributeNames.isEmpty()) {
                nimbusOAuth2UserService.setUserNameAttributeNames(this.userNameAttributeNames);
            }
            this.userInfoService = nimbusOAuth2UserService;
        }
        return this.userInfoService;
    }

    private URL toURL(String urlStr) {
        if (!StringUtils.hasText((String)urlStr)) {
            return null;
        }
        try {
            return new URL(urlStr);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Failed to convert '" + urlStr + "' to a URL: " + ex.getMessage(), ex);
        }
    }
}

