/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.AuthorizationCodeAuthenticationFilterConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.AuthorizationCodeRequestRedirectFilterConfigurer;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.client.authentication.AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.token.SecurityTokenRepository;
import org.springframework.security.oauth2.client.user.OAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthorizationGrantTokenExchanger;
import org.springframework.security.oauth2.client.web.AuthorizationRequestUriBuilder;
import org.springframework.security.oauth2.core.AccessToken;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.security.web.util.matcher.RequestVariablesExtractor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OAuth2LoginConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<OAuth2LoginConfigurer<H>, H> {
    private final AuthorizationCodeRequestRedirectFilterConfigurer authorizationCodeRequestRedirectFilterConfigurer = new AuthorizationCodeRequestRedirectFilterConfigurer();
    private final AuthorizationCodeAuthenticationFilterConfigurer authorizationCodeAuthenticationFilterConfigurer = new AuthorizationCodeAuthenticationFilterConfigurer();
    private final AuthorizationEndpointConfig authorizationEndpointConfig = new AuthorizationEndpointConfig();
    private final TokenEndpointConfig tokenEndpointConfig = new TokenEndpointConfig();
    private final RedirectionEndpointConfig redirectionEndpointConfig = new RedirectionEndpointConfig();
    private final UserInfoEndpointConfig userInfoEndpointConfig = new UserInfoEndpointConfig();

    public OAuth2LoginConfigurer<H> clients(ClientRegistration ... clientRegistrations) {
        Assert.notEmpty((Object[])clientRegistrations, (String)"clientRegistrations cannot be empty");
        return this.clients((ClientRegistrationRepository)new InMemoryClientRegistrationRepository(Arrays.asList(clientRegistrations)));
    }

    public OAuth2LoginConfigurer<H> clients(ClientRegistrationRepository clientRegistrationRepository) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notEmpty((Collection)clientRegistrationRepository.getRegistrations(), (String)"clientRegistrationRepository cannot be empty");
        ((HttpSecurityBuilder)this.getBuilder()).setSharedObject(ClientRegistrationRepository.class, clientRegistrationRepository);
        return this;
    }

    public OAuth2LoginConfigurer<H> userAuthoritiesMapper(GrantedAuthoritiesMapper userAuthoritiesMapper) {
        Assert.notNull((Object)userAuthoritiesMapper, (String)"userAuthoritiesMapper cannot be null");
        this.authorizationCodeAuthenticationFilterConfigurer.userAuthoritiesMapper(userAuthoritiesMapper);
        return this;
    }

    public OAuth2LoginConfigurer<H> successHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        Assert.notNull((Object)authenticationSuccessHandler, (String)"authenticationSuccessHandler cannot be null");
        this.authorizationCodeAuthenticationFilterConfigurer.successHandler(authenticationSuccessHandler);
        return this;
    }

    public OAuth2LoginConfigurer<H> failureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authorizationCodeAuthenticationFilterConfigurer.failureHandler(authenticationFailureHandler);
        return this;
    }

    public AuthorizationEndpointConfig authorizationEndpoint() {
        return this.authorizationEndpointConfig;
    }

    public TokenEndpointConfig tokenEndpoint() {
        return this.tokenEndpointConfig;
    }

    public RedirectionEndpointConfig redirectionEndpoint() {
        return this.redirectionEndpointConfig;
    }

    public UserInfoEndpointConfig userInfoEndpoint() {
        return this.userInfoEndpointConfig;
    }

    @Override
    public void init(H http) throws Exception {
        this.authorizationCodeRequestRedirectFilterConfigurer.setBuilder(http);
        this.authorizationCodeAuthenticationFilterConfigurer.setBuilder(http);
        this.authorizationCodeRequestRedirectFilterConfigurer.init(http);
        this.authorizationCodeAuthenticationFilterConfigurer.init(http);
        this.initDefaultLoginFilter(http);
    }

    @Override
    public void configure(H http) throws Exception {
        this.authorizationCodeRequestRedirectFilterConfigurer.configure(http);
        this.authorizationCodeAuthenticationFilterConfigurer.configure(http);
    }

    static <H extends HttpSecurityBuilder<H>> ClientRegistrationRepository getClientRegistrationRepository(H http) {
        ClientRegistrationRepository clientRegistrationRepository = http.getSharedObject(ClientRegistrationRepository.class);
        if (clientRegistrationRepository == null) {
            clientRegistrationRepository = OAuth2LoginConfigurer.getDefaultClientRegistrationRepository(http);
            http.setSharedObject(ClientRegistrationRepository.class, (ClientRegistrationRepository)clientRegistrationRepository);
        }
        return clientRegistrationRepository;
    }

    private static <H extends HttpSecurityBuilder<H>> ClientRegistrationRepository getDefaultClientRegistrationRepository(H http) {
        return (ClientRegistrationRepository)http.getSharedObject(ApplicationContext.class).getBean(ClientRegistrationRepository.class);
    }

    private void initDefaultLoginFilter(H http) {
        ClientRegistrationRepository clientRegistrationRepository;
        DefaultLoginPageGeneratingFilter loginPageGeneratingFilter = http.getSharedObject(DefaultLoginPageGeneratingFilter.class);
        if (loginPageGeneratingFilter != null && !this.authorizationCodeAuthenticationFilterConfigurer.isCustomLoginPage() && !CollectionUtils.isEmpty((Collection)(clientRegistrationRepository = OAuth2LoginConfigurer.getClientRegistrationRepository((HttpSecurityBuilder)this.getBuilder())).getRegistrations())) {
            String clientAliasTemplateVariable;
            String authorizationRequestPattern;
            Object authorizationRequestMatcher = this.authorizationCodeRequestRedirectFilterConfigurer.getAuthorizationRequestMatcher();
            String authorizationRequestBaseUri = authorizationRequestMatcher != null && AntPathRequestMatcher.class.isAssignableFrom(authorizationRequestMatcher.getClass()) ? ((authorizationRequestPattern = ((AntPathRequestMatcher)authorizationRequestMatcher).getPattern()).endsWith(clientAliasTemplateVariable = "{clientAlias}") ? authorizationRequestPattern.substring(0, authorizationRequestPattern.length() - clientAliasTemplateVariable.length() - 1) : authorizationRequestPattern) : "/oauth2/authorization/code";
            Map<String, String> oauth2AuthenticationUrlToClientName = clientRegistrationRepository.getRegistrations().stream().collect(Collectors.toMap(e -> authorizationRequestBaseUri + "/" + e.getClientAlias(), e -> e.getClientName()));
            loginPageGeneratingFilter.setOauth2LoginEnabled(true);
            loginPageGeneratingFilter.setOauth2AuthenticationUrlToClientName(oauth2AuthenticationUrlToClientName);
            loginPageGeneratingFilter.setLoginPageUrl(this.authorizationCodeAuthenticationFilterConfigurer.getLoginUrl());
            loginPageGeneratingFilter.setFailureUrl(this.authorizationCodeAuthenticationFilterConfigurer.getLoginFailureUrl());
        }
    }

    public class UserInfoEndpointConfig {
        private UserInfoEndpointConfig() {
        }

        public UserInfoEndpointConfig userInfoService(OAuth2UserService userInfoService) {
            Assert.notNull((Object)userInfoService, (String)"userInfoService cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.userInfoService(userInfoService);
            return this;
        }

        public UserInfoEndpointConfig customUserType(Class<? extends OAuth2User> customUserType, URI userInfoUri) {
            Assert.notNull(customUserType, (String)"customUserType cannot be null");
            Assert.notNull((Object)userInfoUri, (String)"userInfoUri cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.customUserType(customUserType, userInfoUri);
            return this;
        }

        public UserInfoEndpointConfig userNameAttributeName(String userNameAttributeName, URI userInfoUri) {
            Assert.hasText((String)userNameAttributeName, (String)"userNameAttributeName cannot be empty");
            Assert.notNull((Object)userInfoUri, (String)"userInfoUri cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.userNameAttributeName(userNameAttributeName, userInfoUri);
            return this;
        }

        public OAuth2LoginConfigurer<H> and() {
            return OAuth2LoginConfigurer.this;
        }
    }

    public class RedirectionEndpointConfig {
        private RedirectionEndpointConfig() {
        }

        public <R extends RequestMatcher & RequestVariablesExtractor> RedirectionEndpointConfig requestMatcher(R authorizationResponseMatcher) {
            Assert.notNull(authorizationResponseMatcher, (String)"authorizationResponseMatcher cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.authorizationResponseMatcher(authorizationResponseMatcher);
            return this;
        }

        public OAuth2LoginConfigurer<H> and() {
            return OAuth2LoginConfigurer.this;
        }
    }

    public class TokenEndpointConfig {
        private TokenEndpointConfig() {
        }

        public TokenEndpointConfig authorizationCodeTokenExchanger(AuthorizationGrantTokenExchanger<AuthorizationCodeAuthenticationToken> authorizationCodeTokenExchanger) {
            Assert.notNull(authorizationCodeTokenExchanger, (String)"authorizationCodeTokenExchanger cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.authorizationCodeTokenExchanger(authorizationCodeTokenExchanger);
            return this;
        }

        public TokenEndpointConfig accessTokenRepository(SecurityTokenRepository<AccessToken> accessTokenRepository) {
            Assert.notNull(accessTokenRepository, (String)"accessTokenRepository cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeAuthenticationFilterConfigurer.accessTokenRepository(accessTokenRepository);
            return this;
        }

        public OAuth2LoginConfigurer<H> and() {
            return OAuth2LoginConfigurer.this;
        }
    }

    public class AuthorizationEndpointConfig {
        private AuthorizationEndpointConfig() {
        }

        public AuthorizationEndpointConfig authorizationRequestBuilder(AuthorizationRequestUriBuilder authorizationRequestBuilder) {
            Assert.notNull((Object)authorizationRequestBuilder, (String)"authorizationRequestBuilder cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeRequestRedirectFilterConfigurer.authorizationRequestBuilder(authorizationRequestBuilder);
            return this;
        }

        public <R extends RequestMatcher & RequestVariablesExtractor> AuthorizationEndpointConfig requestMatcher(R authorizationRequestMatcher) {
            Assert.notNull(authorizationRequestMatcher, (String)"authorizationRequestMatcher cannot be null");
            OAuth2LoginConfigurer.this.authorizationCodeRequestRedirectFilterConfigurer.authorizationRequestMatcher(authorizationRequestMatcher);
            return this;
        }

        public OAuth2LoginConfigurer<H> and() {
            return OAuth2LoginConfigurer.this;
        }
    }
}

