/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UserDetailsRepositoryAuthenticationManager;
import org.springframework.security.config.web.server.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsRepository;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.reactive.result.method.annotation.AuthenticationPrincipalArgumentResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

public class HttpSecurityConfiguration
implements WebFluxConfigurer {
    private static final String BEAN_NAME_PREFIX = "org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.";
    private static final String HTTPSECURITY_BEAN_NAME = "org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.httpSecurity";
    @Autowired(required=false)
    private ReactiveAdapterRegistry adapterRegistry = new ReactiveAdapterRegistry();
    @Autowired(required=false)
    private ReactiveAuthenticationManager authenticationManager;
    @Autowired(required=false)
    private UserDetailsRepository userDetailsRepository;
    @Autowired(required=false)
    private PasswordEncoder passwordEncoder;

    public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
        configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{this.authenticationPrincipalArgumentResolver()});
    }

    @Bean
    public AuthenticationPrincipalArgumentResolver authenticationPrincipalArgumentResolver() {
        return new AuthenticationPrincipalArgumentResolver(this.adapterRegistry);
    }

    @Bean(value={"org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.httpSecurity"})
    @Scope(value="prototype")
    public HttpSecurity httpSecurity() {
        return HttpSecurity.http().authenticationManager(this.authenticationManager()).headers().and().httpBasic().and().formLogin().and();
    }

    private ReactiveAuthenticationManager authenticationManager() {
        if (this.authenticationManager != null) {
            return this.authenticationManager;
        }
        if (this.userDetailsRepository != null) {
            UserDetailsRepositoryAuthenticationManager manager = new UserDetailsRepositoryAuthenticationManager(this.userDetailsRepository);
            if (this.passwordEncoder != null) {
                manager.setPasswordEncoder(this.passwordEncoder);
            }
            return manager;
        }
        return null;
    }
}

