/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.client;

import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

final class OAuth2ClientConfigurerUtils {
    private OAuth2ClientConfigurerUtils() {
    }

    static <B extends HttpSecurityBuilder<B>> ClientRegistrationRepository getClientRegistrationRepository(B builder) {
        ClientRegistrationRepository clientRegistrationRepository = builder.getSharedObject(ClientRegistrationRepository.class);
        if (clientRegistrationRepository == null) {
            clientRegistrationRepository = OAuth2ClientConfigurerUtils.getClientRegistrationRepositoryBean(builder);
            builder.setSharedObject(ClientRegistrationRepository.class, (ClientRegistrationRepository)clientRegistrationRepository);
        }
        return clientRegistrationRepository;
    }

    private static <B extends HttpSecurityBuilder<B>> ClientRegistrationRepository getClientRegistrationRepositoryBean(B builder) {
        return (ClientRegistrationRepository)builder.getSharedObject(ApplicationContext.class).getBean(ClientRegistrationRepository.class);
    }

    static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizedClientService getAuthorizedClientService(B builder) {
        OAuth2AuthorizedClientService authorizedClientService = builder.getSharedObject(OAuth2AuthorizedClientService.class);
        if (authorizedClientService == null) {
            authorizedClientService = OAuth2ClientConfigurerUtils.getAuthorizedClientServiceBean(builder);
            if (authorizedClientService == null) {
                authorizedClientService = new InMemoryOAuth2AuthorizedClientService(OAuth2ClientConfigurerUtils.getClientRegistrationRepository(builder));
            }
            builder.setSharedObject(OAuth2AuthorizedClientService.class, (OAuth2AuthorizedClientService)authorizedClientService);
        }
        return authorizedClientService;
    }

    private static <B extends HttpSecurityBuilder<B>> OAuth2AuthorizedClientService getAuthorizedClientServiceBean(B builder) {
        Map authorizedClientServiceMap = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)builder.getSharedObject(ApplicationContext.class)), OAuth2AuthorizedClientService.class);
        if (authorizedClientServiceMap.size() > 1) {
            throw new NoUniqueBeanDefinitionException(OAuth2AuthorizedClientService.class, authorizedClientServiceMap.size(), "Only one matching @Bean of type " + OAuth2AuthorizedClientService.class.getName() + " should be registered.");
        }
        return !authorizedClientServiceMap.isEmpty() ? (OAuth2AuthorizedClientService)authorizedClientServiceMap.values().iterator().next() : null;
    }
}

