/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.resource;

import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.authentication.OAuth2IntrospectionAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOAuth2TokenIntrospectionClient;
import org.springframework.security.oauth2.server.resource.introspection.OAuth2TokenIntrospectionClient;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationFilter;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.access.BearerTokenAccessDeniedHandler;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;

public final class OAuth2ResourceServerConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<OAuth2ResourceServerConfigurer<H>, H> {
    private final ApplicationContext context;
    private AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver;
    private BearerTokenResolver bearerTokenResolver;
    private JwtConfigurer jwtConfigurer;
    private OpaqueTokenConfigurer opaqueTokenConfigurer;
    private AccessDeniedHandler accessDeniedHandler = new BearerTokenAccessDeniedHandler();
    private AuthenticationEntryPoint authenticationEntryPoint = new BearerTokenAuthenticationEntryPoint();
    private BearerTokenRequestMatcher requestMatcher = new BearerTokenRequestMatcher();

    public OAuth2ResourceServerConfigurer(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        this.context = context;
    }

    public OAuth2ResourceServerConfigurer<H> accessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        Assert.notNull((Object)accessDeniedHandler, (String)"accessDeniedHandler cannot be null");
        this.accessDeniedHandler = accessDeniedHandler;
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> authenticationEntryPoint(AuthenticationEntryPoint entryPoint) {
        Assert.notNull((Object)entryPoint, (String)"entryPoint cannot be null");
        this.authenticationEntryPoint = entryPoint;
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> authenticationManagerResolver(AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver) {
        Assert.notNull(authenticationManagerResolver, (String)"authenticationManagerResolver cannot be null");
        this.authenticationManagerResolver = authenticationManagerResolver;
        return this;
    }

    public OAuth2ResourceServerConfigurer<H> bearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        Assert.notNull((Object)bearerTokenResolver, (String)"bearerTokenResolver cannot be null");
        this.bearerTokenResolver = bearerTokenResolver;
        return this;
    }

    public JwtConfigurer jwt() {
        if (this.jwtConfigurer == null) {
            this.jwtConfigurer = new JwtConfigurer(this.context);
        }
        return this.jwtConfigurer;
    }

    public OpaqueTokenConfigurer opaqueToken() {
        if (this.opaqueTokenConfigurer == null) {
            this.opaqueTokenConfigurer = new OpaqueTokenConfigurer(this.context);
        }
        return this.opaqueTokenConfigurer;
    }

    @Override
    public void init(H http) throws Exception {
        this.registerDefaultAccessDeniedHandler(http);
        this.registerDefaultEntryPoint(http);
        this.registerDefaultCsrfOverride(http);
    }

    @Override
    public void configure(H http) throws Exception {
        BearerTokenResolver bearerTokenResolver = this.getBearerTokenResolver();
        this.requestMatcher.setBearerTokenResolver(bearerTokenResolver);
        if (this.jwtConfigurer != null && this.opaqueTokenConfigurer != null) {
            throw new IllegalStateException("Spring Security only supports JWTs or Opaque Tokens, not both at the same time");
        }
        if (this.jwtConfigurer == null && this.opaqueTokenConfigurer == null && this.authenticationManagerResolver == null) {
            throw new IllegalStateException("Jwt and Opaque Token are the only supported formats for bearer tokens in Spring Security and neither was found. Make sure to configure JWT via http.oauth2ResourceServer().jwt() or Opaque Tokens via http.oauth2ResourceServer().opaque().");
        }
        AuthenticationManagerResolver resolver = this.authenticationManagerResolver;
        if (resolver == null) {
            AuthenticationManager authenticationManager = this.getAuthenticationManager(http);
            resolver = request -> authenticationManager;
        }
        BearerTokenAuthenticationFilter filter = new BearerTokenAuthenticationFilter(resolver);
        filter.setBearerTokenResolver(bearerTokenResolver);
        filter.setAuthenticationEntryPoint(this.authenticationEntryPoint);
        filter = this.postProcess(filter);
        http.addFilter((Filter)filter);
    }

    private void registerDefaultAccessDeniedHandler(H http) {
        ExceptionHandlingConfigurer exceptionHandling = http.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling == null) {
            return;
        }
        exceptionHandling.defaultAccessDeniedHandlerFor(this.accessDeniedHandler, this.requestMatcher);
    }

    private void registerDefaultEntryPoint(H http) {
        ExceptionHandlingConfigurer exceptionHandling = http.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling == null) {
            return;
        }
        exceptionHandling.defaultAuthenticationEntryPointFor(this.authenticationEntryPoint, this.requestMatcher);
    }

    private void registerDefaultCsrfOverride(H http) {
        CsrfConfigurer csrf = http.getConfigurer(CsrfConfigurer.class);
        if (csrf == null) {
            return;
        }
        csrf.ignoringRequestMatchers(this.requestMatcher);
    }

    AuthenticationManager getAuthenticationManager(H http) {
        if (this.jwtConfigurer != null) {
            return this.jwtConfigurer.getAuthenticationManager(http);
        }
        if (this.opaqueTokenConfigurer != null) {
            return this.opaqueTokenConfigurer.getAuthenticationManager(http);
        }
        return http.getSharedObject(AuthenticationManager.class);
    }

    BearerTokenResolver getBearerTokenResolver() {
        if (this.bearerTokenResolver == null) {
            this.bearerTokenResolver = this.context.getBeanNamesForType(BearerTokenResolver.class).length > 0 ? (BearerTokenResolver)this.context.getBean(BearerTokenResolver.class) : new DefaultBearerTokenResolver();
        }
        return this.bearerTokenResolver;
    }

    private static final class BearerTokenRequestMatcher
    implements RequestMatcher {
        private BearerTokenResolver bearerTokenResolver;

        private BearerTokenRequestMatcher() {
        }

        public boolean matches(HttpServletRequest request) {
            try {
                return this.bearerTokenResolver.resolve(request) != null;
            }
            catch (OAuth2AuthenticationException e) {
                return false;
            }
        }

        public void setBearerTokenResolver(BearerTokenResolver tokenResolver) {
            Assert.notNull((Object)tokenResolver, (String)"resolver cannot be null");
            this.bearerTokenResolver = tokenResolver;
        }
    }

    public class OpaqueTokenConfigurer {
        private final ApplicationContext context;
        private AuthenticationManager authenticationManager;
        private String introspectionUri;
        private String clientId;
        private String clientSecret;
        private Supplier<OAuth2TokenIntrospectionClient> introspectionClient;

        OpaqueTokenConfigurer(ApplicationContext context) {
            this.context = context;
        }

        public OpaqueTokenConfigurer authenticationManager(AuthenticationManager authenticationManager) {
            Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
            this.authenticationManager = authenticationManager;
            return this;
        }

        public OpaqueTokenConfigurer introspectionUri(String introspectionUri) {
            Assert.notNull((Object)introspectionUri, (String)"introspectionUri cannot be null");
            this.introspectionUri = introspectionUri;
            this.introspectionClient = () -> new NimbusOAuth2TokenIntrospectionClient(this.introspectionUri, this.clientId, this.clientSecret);
            return this;
        }

        public OpaqueTokenConfigurer introspectionClientCredentials(String clientId, String clientSecret) {
            Assert.notNull((Object)clientId, (String)"clientId cannot be null");
            Assert.notNull((Object)clientSecret, (String)"clientSecret cannot be null");
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.introspectionClient = () -> new NimbusOAuth2TokenIntrospectionClient(this.introspectionUri, this.clientId, this.clientSecret);
            return this;
        }

        public OpaqueTokenConfigurer introspectionClient(OAuth2TokenIntrospectionClient introspectionClient) {
            Assert.notNull((Object)introspectionClient, (String)"introspectionClient cannot be null");
            this.introspectionClient = () -> introspectionClient;
            return this;
        }

        OAuth2TokenIntrospectionClient getIntrospectionClient() {
            if (this.introspectionClient != null) {
                return this.introspectionClient.get();
            }
            return (OAuth2TokenIntrospectionClient)this.context.getBean(OAuth2TokenIntrospectionClient.class);
        }

        AuthenticationManager getAuthenticationManager(H http) {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            OAuth2TokenIntrospectionClient introspectionClient = this.getIntrospectionClient();
            OAuth2IntrospectionAuthenticationProvider provider = new OAuth2IntrospectionAuthenticationProvider(introspectionClient);
            http.authenticationProvider((AuthenticationProvider)provider);
            return http.getSharedObject(AuthenticationManager.class);
        }
    }

    public class JwtConfigurer {
        private final ApplicationContext context;
        private AuthenticationManager authenticationManager;
        private JwtDecoder decoder;
        private Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter = new JwtAuthenticationConverter();

        JwtConfigurer(ApplicationContext context) {
            this.context = context;
        }

        public JwtConfigurer authenticationManager(AuthenticationManager authenticationManager) {
            Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
            this.authenticationManager = authenticationManager;
            return this;
        }

        public JwtConfigurer decoder(JwtDecoder decoder) {
            this.decoder = decoder;
            return this;
        }

        public JwtConfigurer jwkSetUri(String uri) {
            this.decoder = NimbusJwtDecoder.withJwkSetUri((String)uri).build();
            return this;
        }

        public JwtConfigurer jwtAuthenticationConverter(Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter) {
            this.jwtAuthenticationConverter = jwtAuthenticationConverter;
            return this;
        }

        public OAuth2ResourceServerConfigurer<H> and() {
            return OAuth2ResourceServerConfigurer.this;
        }

        Converter<Jwt, ? extends AbstractAuthenticationToken> getJwtAuthenticationConverter() {
            return this.jwtAuthenticationConverter;
        }

        JwtDecoder getJwtDecoder() {
            if (this.decoder == null) {
                return (JwtDecoder)this.context.getBean(JwtDecoder.class);
            }
            return this.decoder;
        }

        AuthenticationManager getAuthenticationManager(H http) {
            if (this.authenticationManager != null) {
                return this.authenticationManager;
            }
            JwtDecoder decoder = this.getJwtDecoder();
            Converter<Jwt, ? extends AbstractAuthenticationToken> jwtAuthenticationConverter = this.getJwtAuthenticationConverter();
            JwtAuthenticationProvider provider = new JwtAuthenticationProvider(decoder);
            provider.setJwtAuthenticationConverter(jwtAuthenticationConverter);
            AuthenticationProvider authenticationProvider = (AuthenticationProvider)OAuth2ResourceServerConfigurer.this.postProcess(provider);
            http.authenticationProvider(authenticationProvider);
            return http.getSharedObject(AuthenticationManager.class);
        }
    }
}

