/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.hierarchicalroles.NullRoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.authorization.AuthorizationManagerFactory;
import org.springframework.security.authorization.DefaultAuthorizationManagerFactory;
import org.springframework.security.config.annotation.web.AbstractRequestMatcherDsl;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.core.GrantedAuthorityDefaults;
import org.springframework.security.web.access.IpAddressAuthorizationManager;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00152\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013J\u0016\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u00132\u0006\u0010\u001a\u001a\u00020\u0015J'\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u00132\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001d\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001eJ'\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u00132\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001d\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001eJ\u0016\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u00132\u0006\u0010!\u001a\u00020\u0015J'\u0010\"\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u00132\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001d\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001eJ'\u0010$\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u00132\u0012\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u001d\"\u00020\u0015\u00a2\u0006\u0002\u0010\u001eJ\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010&\u001a\u00020\u0015J#\u00100\u001a\u0018\u0012\u000e\u0012\f02R\b\u0012\u0004\u0012\u00020403\u0012\u0004\u0012\u00020\u000f01H\u0000\u00a2\u0006\u0002\b5J\u0018\u00106\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00107\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010'\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0019\u0010*\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0019\u0010,\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0019\u0010.\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)\u00a8\u0006:"}, d2={"Lorg/springframework/security/config/annotation/web/AuthorizeHttpRequestsDsl;", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl;", "context", "Lorg/springframework/context/ApplicationContext;", "<init>", "(Lorg/springframework/context/ApplicationContext;)V", "authorizationRules", "", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$AuthorizationManagerRule;", "authorizationManagerFactory", "Lorg/springframework/security/authorization/AuthorizationManagerFactory;", "Lorg/springframework/security/web/access/intercept/RequestAuthorizationContext;", "PATTERN_TYPE", "Lorg/springframework/security/config/annotation/web/AbstractRequestMatcherDsl$PatternType;", "authorize", "", "matches", "Lorg/springframework/security/web/util/matcher/RequestMatcher;", "access", "Lorg/springframework/security/authorization/AuthorizationManager;", "pattern", "", "method", "Lorg/springframework/http/HttpMethod;", "servletPath", "hasAuthority", "authority", "hasAnyAuthority", "authorities", "", "([Ljava/lang/String;)Lorg/springframework/security/authorization/AuthorizationManager;", "hasAllAuthorities", "hasRole", "role", "hasAnyRole", "roles", "hasAllRoles", "hasIpAddress", "ipAddress", "permitAll", "getPermitAll", "()Lorg/springframework/security/authorization/AuthorizationManager;", "denyAll", "getDenyAll", "authenticated", "getAuthenticated", "fullyAuthenticated", "getFullyAuthenticated", "get", "Lkotlin/Function1;", "Lorg/springframework/security/config/annotation/web/configurers/AuthorizeHttpRequestsConfigurer$AuthorizationManagerRequestMatcherRegistry;", "Lorg/springframework/security/config/annotation/web/configurers/AuthorizeHttpRequestsConfigurer;", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "get$spring_security_config", "resolveAuthorizationManagerFactory", "resolveRolePrefix", "resolveRoleHierarchy", "Lorg/springframework/security/access/hierarchicalroles/RoleHierarchy;", "spring-security-config"})
@SourceDebugExtension(value={"SMAP\nAuthorizeHttpRequestsDsl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizeHttpRequestsDsl.kt\norg/springframework/security/config/annotation/web/AuthorizeHttpRequestsDsl\n+ 2 BeanFactoryExtensions.kt\norg/springframework/beans/factory/BeanFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n63#2:324\n1869#3,2:325\n*S KotlinDebug\n*F\n+ 1 AuthorizeHttpRequestsDsl.kt\norg/springframework/security/config/annotation/web/AuthorizeHttpRequestsDsl\n*L\n285#1:324\n259#1:325,2\n*E\n"})
public final class AuthorizeHttpRequestsDsl
extends AbstractRequestMatcherDsl {
    @NotNull
    private final List<AbstractRequestMatcherDsl.AuthorizationManagerRule> authorizationRules;
    @NotNull
    private final AuthorizationManagerFactory<? super RequestAuthorizationContext> authorizationManagerFactory;
    @NotNull
    private final AbstractRequestMatcherDsl.PatternType PATTERN_TYPE;
    @NotNull
    private final AuthorizationManager<? super RequestAuthorizationContext> permitAll;
    @NotNull
    private final AuthorizationManager<? super RequestAuthorizationContext> denyAll;
    @NotNull
    private final AuthorizationManager<? super RequestAuthorizationContext> authenticated;
    @NotNull
    private final AuthorizationManager<? super RequestAuthorizationContext> fullyAuthenticated;

    public final void authorize(@NotNull RequestMatcher matches, @NotNull AuthorizationManager<? super RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)matches, (String)"matches");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule(matches, access));
    }

    public static /* synthetic */ void authorize$default(AuthorizeHttpRequestsDsl authorizeHttpRequestsDsl, RequestMatcher requestMatcher, AuthorizationManager authorizationManager, int n, Object object) {
        if ((n & 1) != 0) {
            RequestMatcher requestMatcher2 = AnyRequestMatcher.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)requestMatcher2, (String)"INSTANCE");
            requestMatcher = requestMatcher2;
        }
        authorizeHttpRequestsDsl.authorize(requestMatcher, (AuthorizationManager<? super RequestAuthorizationContext>)authorizationManager);
    }

    public final void authorize(@NotNull String pattern, @NotNull AuthorizationManager<? super RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, null, null, access, 12, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull AuthorizationManager<? super RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, null, method, access, 4, null));
    }

    public final void authorize(@NotNull String pattern, @NotNull String servletPath, @NotNull AuthorizationManager<? super RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, servletPath, null, access, 8, null));
    }

    public final void authorize(@NotNull HttpMethod method, @NotNull String pattern, @NotNull String servletPath, @NotNull AuthorizationManager<? super RequestAuthorizationContext> access) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)servletPath, (String)"servletPath");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.authorizationRules.add(new AbstractRequestMatcherDsl.PatternAuthorizationManagerRule(pattern, this.PATTERN_TYPE, servletPath, method, access));
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> hasAuthority(@NotNull String authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        AuthorizationManager authorizationManager = this.authorizationManagerFactory.hasAuthority(authority);
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager, (String)"hasAuthority(...)");
        return authorizationManager;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> hasAnyAuthority(String ... authorities) {
        Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
        AuthorizationManager authorizationManager = this.authorizationManagerFactory.hasAnyAuthority(Arrays.copyOf(authorities, authorities.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager, (String)"hasAnyAuthority(...)");
        return authorizationManager;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> hasAllAuthorities(String ... authorities) {
        Intrinsics.checkNotNullParameter((Object)authorities, (String)"authorities");
        AuthorizationManager authorizationManager = this.authorizationManagerFactory.hasAllAuthorities(Arrays.copyOf(authorities, authorities.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager, (String)"hasAllAuthorities(...)");
        return authorizationManager;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> hasRole(@NotNull String role) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        AuthorizationManager authorizationManager = this.authorizationManagerFactory.hasRole(role);
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager, (String)"hasRole(...)");
        return authorizationManager;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> hasAnyRole(String ... roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        AuthorizationManager authorizationManager = this.authorizationManagerFactory.hasAnyRole(Arrays.copyOf(roles, roles.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager, (String)"hasAnyRole(...)");
        return authorizationManager;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> hasAllRoles(String ... roles) {
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        AuthorizationManager authorizationManager = this.authorizationManagerFactory.hasAllRoles(Arrays.copyOf(roles, roles.length));
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager, (String)"hasAllRoles(...)");
        return authorizationManager;
    }

    @NotNull
    public final AuthorizationManager<RequestAuthorizationContext> hasIpAddress(@NotNull String ipAddress) {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        IpAddressAuthorizationManager ipAddressAuthorizationManager = IpAddressAuthorizationManager.hasIpAddress((String)ipAddress);
        Intrinsics.checkNotNullExpressionValue((Object)ipAddressAuthorizationManager, (String)"hasIpAddress(...)");
        return (AuthorizationManager)ipAddressAuthorizationManager;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> getPermitAll() {
        return this.permitAll;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> getDenyAll() {
        return this.denyAll;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> getAuthenticated() {
        return this.authenticated;
    }

    @NotNull
    public final AuthorizationManager<? super RequestAuthorizationContext> getFullyAuthenticated() {
        return this.fullyAuthenticated;
    }

    @NotNull
    public final Function1<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry, Unit> get$spring_security_config() {
        return arg_0 -> AuthorizeHttpRequestsDsl.get$lambda$0(this, arg_0);
    }

    public AuthorizeHttpRequestsDsl(@NotNull ApplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.authorizationRules = new ArrayList();
        this.PATTERN_TYPE = AbstractRequestMatcherDsl.PatternType.PATH;
        this.authorizationManagerFactory = this.resolveAuthorizationManagerFactory(context);
        AuthorizationManager authorizationManager = this.authorizationManagerFactory.authenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager, (String)"authenticated(...)");
        this.authenticated = authorizationManager;
        AuthorizationManager authorizationManager2 = this.authorizationManagerFactory.denyAll();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager2, (String)"denyAll(...)");
        this.denyAll = authorizationManager2;
        AuthorizationManager authorizationManager3 = this.authorizationManagerFactory.fullyAuthenticated();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager3, (String)"fullyAuthenticated(...)");
        this.fullyAuthenticated = authorizationManager3;
        AuthorizationManager authorizationManager4 = this.authorizationManagerFactory.permitAll();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationManager4, (String)"permitAll(...)");
        this.permitAll = authorizationManager4;
    }

    private final AuthorizationManagerFactory<? super RequestAuthorizationContext> resolveAuthorizationManagerFactory(ApplicationContext context) {
        RoleHierarchy roleHierarchy;
        BeanFactory $this$getBeanProvider$iv = (BeanFactory)context;
        boolean $i$f$getBeanProvider = false;
        ObjectProvider objectProvider = $this$getBeanProvider$iv.getBeanProvider(ResolvableType.forType((Type)new ParameterizedTypeReference<AuthorizationManagerFactory<RequestAuthorizationContext>>(){}.getType()));
        Intrinsics.checkNotNullExpressionValue((Object)objectProvider, (String)"getBeanProvider(...)");
        AuthorizationManagerFactory factoryOfRequestAuthorizationContext = (AuthorizationManagerFactory)objectProvider.getIfUnique();
        if (factoryOfRequestAuthorizationContext != null) {
            return factoryOfRequestAuthorizationContext;
        }
        Class[] classArray = new Class[]{Object.class};
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(AuthorizationManagerFactory.class, (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)resolvableType, (String)"forClassWithGenerics(...)");
        ResolvableType factoryOfObjectType = resolvableType;
        AuthorizationManagerFactory factoryOfAny = (AuthorizationManagerFactory)context.getBeanProvider(factoryOfObjectType).getIfUnique();
        if (factoryOfAny != null) {
            return factoryOfAny;
        }
        DefaultAuthorizationManagerFactory defaultFactory = new DefaultAuthorizationManagerFactory();
        String rolePrefix = this.resolveRolePrefix(context);
        if (rolePrefix != null) {
            defaultFactory.setRolePrefix(rolePrefix);
        }
        if ((roleHierarchy = this.resolveRoleHierarchy(context)) != null) {
            defaultFactory.setRoleHierarchy(roleHierarchy);
        }
        return (AuthorizationManagerFactory)defaultFactory;
    }

    private final String resolveRolePrefix(ApplicationContext context) {
        String[] stringArray = context.getBeanNamesForType(GrantedAuthorityDefaults.class);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getBeanNamesForType(...)");
        String[] beanNames = stringArray;
        if (!(beanNames.length == 0)) {
            String string = ((GrantedAuthorityDefaults)context.getBean(GrantedAuthorityDefaults.class)).getRolePrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRolePrefix(...)");
            return string;
        }
        return "ROLE_";
    }

    private final RoleHierarchy resolveRoleHierarchy(ApplicationContext context) {
        String[] stringArray = context.getBeanNamesForType(RoleHierarchy.class);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getBeanNamesForType(...)");
        String[] beanNames = stringArray;
        if (!(beanNames.length == 0)) {
            Object object = context.getBean(RoleHierarchy.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
            return (RoleHierarchy)object;
        }
        return (RoleHierarchy)new NullRoleHierarchy();
    }

    private static final Unit get$lambda$0(AuthorizeHttpRequestsDsl this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry requests) {
        Intrinsics.checkNotNullParameter((Object)requests, (String)"requests");
        Iterable $this$forEach$iv = this$0.authorizationRules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AbstractRequestMatcherDsl.AuthorizationManagerRule rule = (AbstractRequestMatcherDsl.AuthorizationManagerRule)element$iv;
            boolean bl = false;
            AbstractRequestMatcherDsl.AuthorizationManagerRule authorizationManagerRule = rule;
            if (authorizationManagerRule instanceof AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule) {
                RequestMatcher[] requestMatcherArray = new RequestMatcher[]{((AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule)rule).getMatcher()};
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(((AbstractRequestMatcherDsl.MatcherAuthorizationManagerRule)rule).getRule());
                continue;
            }
            if (!(authorizationManagerRule instanceof AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)) continue;
            Object object = requests.getApplicationContext().getBeanProvider(PathPatternRequestMatcher.Builder.class).getIfUnique(PathPatternRequestMatcher::withDefaults);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getIfUnique(...)");
            PathPatternRequestMatcher.Builder builder = (PathPatternRequestMatcher.Builder)object;
            if (((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getServletPath() != null) {
                PathPatternRequestMatcher.Builder builder2 = builder.basePath(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getServletPath());
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"basePath(...)");
                builder = builder2;
            }
            RequestMatcher[] requestMatcherArray = new RequestMatcher[]{builder.matcher(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getHttpMethod(), ((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getPattern())};
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(requestMatcherArray)).access(((AbstractRequestMatcherDsl.PatternAuthorizationManagerRule)rule).getRule());
        }
        return Unit.INSTANCE;
    }
}

