/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import jakarta.servlet.Filter;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListenerAdapter;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AbstractOAuth2Configurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.AuthorizationServerContextFilter;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2AuthorizationServerMetadataEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ClientAuthenticationConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ClientRegistrationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2ConfigurerUtils;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2DeviceAuthorizationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2DeviceVerificationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2PushedAuthorizationRequestEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenIntrospectionEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OAuth2TokenRevocationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcClientRegistrationEndpointConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.authorization.OidcUserInfoEndpointConfigurer;
import org.springframework.security.context.DelegatingApplicationListener;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsentService;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationException;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeRequestAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContext;
import org.springframework.security.oauth2.server.authorization.context.AuthorizationServerContextHolder;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.web.NimbusJwkSetEndpointFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2AuthorizationServerConfigurer
extends AbstractHttpConfigurer<OAuth2AuthorizationServerConfigurer, HttpSecurity> {
    private final Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = this.createConfigurers();
    private RequestMatcher endpointsMatcher;

    public OAuth2AuthorizationServerConfigurer registeredClientRepository(RegisteredClientRepository registeredClientRepository) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(RegisteredClientRepository.class, registeredClientRepository);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationService(OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(OAuth2AuthorizationService.class, authorizationService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationConsentService(OAuth2AuthorizationConsentService authorizationConsentService) {
        Assert.notNull((Object)authorizationConsentService, (String)"authorizationConsentService cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(OAuth2AuthorizationConsentService.class, authorizationConsentService);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationServerSettings(AuthorizationServerSettings authorizationServerSettings) {
        Assert.notNull((Object)authorizationServerSettings, (String)"authorizationServerSettings cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(AuthorizationServerSettings.class, authorizationServerSettings);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenGenerator(OAuth2TokenGenerator<? extends OAuth2Token> tokenGenerator) {
        Assert.notNull(tokenGenerator, (String)"tokenGenerator cannot be null");
        ((HttpSecurity)this.getBuilder()).setSharedObject(OAuth2TokenGenerator.class, tokenGenerator);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer clientAuthentication(Customizer<OAuth2ClientAuthenticationConfigurer> clientAuthenticationCustomizer) {
        clientAuthenticationCustomizer.customize(this.getConfigurer(OAuth2ClientAuthenticationConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationServerMetadataEndpoint(Customizer<OAuth2AuthorizationServerMetadataEndpointConfigurer> authorizationServerMetadataEndpointCustomizer) {
        authorizationServerMetadataEndpointCustomizer.customize(this.getConfigurer(OAuth2AuthorizationServerMetadataEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer authorizationEndpoint(Customizer<OAuth2AuthorizationEndpointConfigurer> authorizationEndpointCustomizer) {
        authorizationEndpointCustomizer.customize(this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer pushedAuthorizationRequestEndpoint(Customizer<OAuth2PushedAuthorizationRequestEndpointConfigurer> pushedAuthorizationRequestEndpointCustomizer) {
        OAuth2PushedAuthorizationRequestEndpointConfigurer pushedAuthorizationRequestEndpointConfigurer = this.getConfigurer(OAuth2PushedAuthorizationRequestEndpointConfigurer.class);
        if (pushedAuthorizationRequestEndpointConfigurer == null) {
            this.addConfigurer(OAuth2PushedAuthorizationRequestEndpointConfigurer.class, new OAuth2PushedAuthorizationRequestEndpointConfigurer(x$0 -> this.postProcess(x$0)));
            pushedAuthorizationRequestEndpointConfigurer = this.getConfigurer(OAuth2PushedAuthorizationRequestEndpointConfigurer.class);
        }
        pushedAuthorizationRequestEndpointCustomizer.customize(pushedAuthorizationRequestEndpointConfigurer);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenEndpoint(Customizer<OAuth2TokenEndpointConfigurer> tokenEndpointCustomizer) {
        tokenEndpointCustomizer.customize(this.getConfigurer(OAuth2TokenEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenIntrospectionEndpoint(Customizer<OAuth2TokenIntrospectionEndpointConfigurer> tokenIntrospectionEndpointCustomizer) {
        tokenIntrospectionEndpointCustomizer.customize(this.getConfigurer(OAuth2TokenIntrospectionEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer tokenRevocationEndpoint(Customizer<OAuth2TokenRevocationEndpointConfigurer> tokenRevocationEndpointCustomizer) {
        tokenRevocationEndpointCustomizer.customize(this.getConfigurer(OAuth2TokenRevocationEndpointConfigurer.class));
        return this;
    }

    public OAuth2AuthorizationServerConfigurer deviceAuthorizationEndpoint(Customizer<OAuth2DeviceAuthorizationEndpointConfigurer> deviceAuthorizationEndpointCustomizer) {
        OAuth2DeviceAuthorizationEndpointConfigurer deviceAuthorizationEndpointConfigurer = this.getConfigurer(OAuth2DeviceAuthorizationEndpointConfigurer.class);
        if (deviceAuthorizationEndpointConfigurer == null) {
            this.addConfigurer(OAuth2DeviceAuthorizationEndpointConfigurer.class, new OAuth2DeviceAuthorizationEndpointConfigurer(x$0 -> this.postProcess(x$0)));
            deviceAuthorizationEndpointConfigurer = this.getConfigurer(OAuth2DeviceAuthorizationEndpointConfigurer.class);
            this.deviceVerificationEndpoint(configurer -> {});
        }
        deviceAuthorizationEndpointCustomizer.customize(deviceAuthorizationEndpointConfigurer);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer deviceVerificationEndpoint(Customizer<OAuth2DeviceVerificationEndpointConfigurer> deviceVerificationEndpointCustomizer) {
        OAuth2DeviceVerificationEndpointConfigurer deviceVerificationEndpointConfigurer = this.getConfigurer(OAuth2DeviceVerificationEndpointConfigurer.class);
        if (deviceVerificationEndpointConfigurer == null) {
            this.addConfigurer(OAuth2DeviceVerificationEndpointConfigurer.class, new OAuth2DeviceVerificationEndpointConfigurer(x$0 -> this.postProcess(x$0)));
            deviceVerificationEndpointConfigurer = this.getConfigurer(OAuth2DeviceVerificationEndpointConfigurer.class);
            this.deviceAuthorizationEndpoint(configurer -> {});
        }
        deviceVerificationEndpointCustomizer.customize(deviceVerificationEndpointConfigurer);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer clientRegistrationEndpoint(Customizer<OAuth2ClientRegistrationEndpointConfigurer> clientRegistrationEndpointCustomizer) {
        OAuth2ClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OAuth2ClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer == null) {
            this.addConfigurer(OAuth2ClientRegistrationEndpointConfigurer.class, new OAuth2ClientRegistrationEndpointConfigurer(x$0 -> this.postProcess(x$0)));
            clientRegistrationEndpointConfigurer = this.getConfigurer(OAuth2ClientRegistrationEndpointConfigurer.class);
        }
        clientRegistrationEndpointCustomizer.customize(clientRegistrationEndpointConfigurer);
        return this;
    }

    public OAuth2AuthorizationServerConfigurer oidc(Customizer<OidcConfigurer> oidcCustomizer) {
        OidcConfigurer oidcConfigurer = this.getConfigurer(OidcConfigurer.class);
        if (oidcConfigurer == null) {
            this.addConfigurer(OidcConfigurer.class, new OidcConfigurer(x$0 -> this.postProcess(x$0)));
            oidcConfigurer = this.getConfigurer(OidcConfigurer.class);
        }
        oidcCustomizer.customize(oidcConfigurer);
        return this;
    }

    public RequestMatcher getEndpointsMatcher() {
        return request -> this.endpointsMatcher.matches(request);
    }

    @Override
    public void init(HttpSecurity httpSecurity) {
        OidcConfigurer oidcConfigurer;
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        OAuth2AuthorizationServerConfigurer.validateAuthorizationServerSettings(authorizationServerSettings);
        if (this.isOidcEnabled()) {
            OAuth2AuthorizationServerConfigurer.initSessionRegistry(httpSecurity);
            SessionRegistry sessionRegistry = httpSecurity.getSharedObject(SessionRegistry.class);
            authorizationEndpointConfigurer = this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class);
            authorizationEndpointConfigurer.setSessionAuthenticationStrategy((authentication, request, response) -> {
                OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication;
                if (authentication instanceof OAuth2AuthorizationCodeRequestAuthenticationToken && (authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authentication).getScopes().contains("openid") && sessionRegistry.getSessionInformation(request.getSession().getId()) == null) {
                    sessionRegistry.registerNewSession(request.getSession().getId(), ((Authentication)authorizationCodeRequestAuthentication.getPrincipal()).getPrincipal());
                }
            });
        } else {
            Consumer<OAuth2AuthorizationCodeRequestAuthenticationContext> oidcAuthenticationRequestValidator = authenticationContext -> {
                OAuth2AuthorizationCodeRequestAuthenticationToken authorizationCodeRequestAuthentication = (OAuth2AuthorizationCodeRequestAuthenticationToken)authenticationContext.getAuthentication();
                if (authorizationCodeRequestAuthentication.getScopes().contains("openid")) {
                    OAuth2Error error = new OAuth2Error("invalid_scope", "OpenID Connect 1.0 authentication requests are restricted.", "https://datatracker.ietf.org/doc/html/rfc6749#section-4.1.2.1");
                    throw new OAuth2AuthorizationCodeRequestAuthenticationException(error, authorizationCodeRequestAuthentication);
                }
            };
            authorizationEndpointConfigurer = this.getConfigurer(OAuth2AuthorizationEndpointConfigurer.class);
            authorizationEndpointConfigurer.addAuthorizationCodeRequestAuthenticationValidator(oidcAuthenticationRequestValidator);
            OAuth2PushedAuthorizationRequestEndpointConfigurer pushedAuthorizationRequestEndpointConfigurer = this.getConfigurer(OAuth2PushedAuthorizationRequestEndpointConfigurer.class);
            if (pushedAuthorizationRequestEndpointConfigurer != null) {
                pushedAuthorizationRequestEndpointConfigurer.addAuthorizationCodeRequestAuthenticationValidator(oidcAuthenticationRequestValidator);
            }
        }
        ArrayList<PathPatternRequestMatcher> requestMatchers = new ArrayList<PathPatternRequestMatcher>();
        this.configurers.values().forEach(configurer -> {
            configurer.init(httpSecurity);
            requestMatchers.add((PathPatternRequestMatcher)configurer.getRequestMatcher());
        });
        String jwkSetEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getJwkSetEndpoint()) : authorizationServerSettings.getJwkSetEndpoint();
        requestMatchers.add(PathPatternRequestMatcher.withDefaults().matcher(HttpMethod.GET, jwkSetEndpointUri));
        this.endpointsMatcher = new OrRequestMatcher(requestMatchers);
        ExceptionHandlingConfigurer exceptionHandling = httpSecurity.getConfigurer(ExceptionHandlingConfigurer.class);
        if (exceptionHandling != null) {
            ArrayList<RequestMatcher> preferredMatchers = new ArrayList<RequestMatcher>();
            preferredMatchers.add(this.getRequestMatcher(OAuth2TokenEndpointConfigurer.class));
            preferredMatchers.add(this.getRequestMatcher(OAuth2TokenIntrospectionEndpointConfigurer.class));
            preferredMatchers.add(this.getRequestMatcher(OAuth2TokenRevocationEndpointConfigurer.class));
            RequestMatcher preferredMatcher = this.getRequestMatcher(OAuth2DeviceAuthorizationEndpointConfigurer.class);
            if (preferredMatcher != null) {
                preferredMatchers.add(preferredMatcher);
            }
            if ((preferredMatcher = this.getRequestMatcher(OAuth2PushedAuthorizationRequestEndpointConfigurer.class)) != null) {
                preferredMatchers.add(preferredMatcher);
            }
            exceptionHandling.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED), (RequestMatcher)new OrRequestMatcher(preferredMatchers));
        }
        httpSecurity.csrf(csrf -> csrf.ignoringRequestMatchers(this.endpointsMatcher));
        if (this.getConfigurer(OAuth2ClientRegistrationEndpointConfigurer.class) != null) {
            httpSecurity.oauth2ResourceServer(oauth2ResourceServer -> oauth2ResourceServer.jwt(Customizer.withDefaults()));
        }
        if ((oidcConfigurer = this.getConfigurer(OidcConfigurer.class)) != null && (oidcConfigurer.getConfigurer(OidcUserInfoEndpointConfigurer.class) != null || oidcConfigurer.getConfigurer(OidcClientRegistrationEndpointConfigurer.class) != null)) {
            httpSecurity.oauth2ResourceServer(oauth2ResourceServer -> oauth2ResourceServer.jwt(Customizer.withDefaults()));
        }
    }

    @Override
    public void configure(HttpSecurity httpSecurity) {
        OAuth2PushedAuthorizationRequestEndpointConfigurer pushedAuthorizationRequestEndpointConfigurer;
        OAuth2DeviceAuthorizationEndpointConfigurer deviceAuthorizationEndpointConfigurer;
        OAuth2ClientRegistrationEndpointConfigurer clientRegistrationEndpointConfigurer = this.getConfigurer(OAuth2ClientRegistrationEndpointConfigurer.class);
        if (clientRegistrationEndpointConfigurer != null) {
            OAuth2AuthorizationServerMetadataEndpointConfigurer authorizationServerMetadataEndpointConfigurer = this.getConfigurer(OAuth2AuthorizationServerMetadataEndpointConfigurer.class);
            authorizationServerMetadataEndpointConfigurer.addDefaultAuthorizationServerMetadataCustomizer(builder -> {
                AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
                String issuer = authorizationServerContext.getIssuer();
                AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
                String clientRegistrationEndpoint = UriComponentsBuilder.fromUriString((String)issuer).path(authorizationServerSettings.getClientRegistrationEndpoint()).build().toUriString();
                builder.clientRegistrationEndpoint(clientRegistrationEndpoint);
            });
        }
        if ((deviceAuthorizationEndpointConfigurer = this.getConfigurer(OAuth2DeviceAuthorizationEndpointConfigurer.class)) != null) {
            OAuth2AuthorizationServerMetadataEndpointConfigurer authorizationServerMetadataEndpointConfigurer = this.getConfigurer(OAuth2AuthorizationServerMetadataEndpointConfigurer.class);
            authorizationServerMetadataEndpointConfigurer.addDefaultAuthorizationServerMetadataCustomizer(builder -> {
                AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
                String issuer = authorizationServerContext.getIssuer();
                AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
                String deviceAuthorizationEndpoint = UriComponentsBuilder.fromUriString((String)issuer).path(authorizationServerSettings.getDeviceAuthorizationEndpoint()).build().toUriString();
                builder.deviceAuthorizationEndpoint(deviceAuthorizationEndpoint);
                builder.grantType(AuthorizationGrantType.DEVICE_CODE.getValue());
            });
        }
        if ((pushedAuthorizationRequestEndpointConfigurer = this.getConfigurer(OAuth2PushedAuthorizationRequestEndpointConfigurer.class)) != null) {
            OAuth2AuthorizationServerMetadataEndpointConfigurer authorizationServerMetadataEndpointConfigurer = this.getConfigurer(OAuth2AuthorizationServerMetadataEndpointConfigurer.class);
            authorizationServerMetadataEndpointConfigurer.addDefaultAuthorizationServerMetadataCustomizer(builder -> {
                AuthorizationServerContext authorizationServerContext = AuthorizationServerContextHolder.getContext();
                String issuer = authorizationServerContext.getIssuer();
                AuthorizationServerSettings authorizationServerSettings = authorizationServerContext.getAuthorizationServerSettings();
                String pushedAuthorizationRequestEndpoint = UriComponentsBuilder.fromUriString((String)issuer).path(authorizationServerSettings.getPushedAuthorizationRequestEndpoint()).build().toUriString();
                builder.pushedAuthorizationRequestEndpoint(pushedAuthorizationRequestEndpoint);
            });
        }
        this.configurers.values().forEach(configurer -> configurer.configure(httpSecurity));
        AuthorizationServerSettings authorizationServerSettings = OAuth2ConfigurerUtils.getAuthorizationServerSettings(httpSecurity);
        AuthorizationServerContextFilter authorizationServerContextFilter = new AuthorizationServerContextFilter(authorizationServerSettings);
        httpSecurity.addFilterAfter((Filter)this.postProcess(authorizationServerContextFilter), SecurityContextHolderFilter.class);
        JWKSource<SecurityContext> jwkSource = OAuth2ConfigurerUtils.getJwkSource(httpSecurity);
        if (jwkSource != null) {
            String jwkSetEndpointUri = authorizationServerSettings.isMultipleIssuersAllowed() ? OAuth2ConfigurerUtils.withMultipleIssuersPattern(authorizationServerSettings.getJwkSetEndpoint()) : authorizationServerSettings.getJwkSetEndpoint();
            NimbusJwkSetEndpointFilter jwkSetEndpointFilter = new NimbusJwkSetEndpointFilter(jwkSource, jwkSetEndpointUri);
            httpSecurity.addFilterBefore((Filter)this.postProcess(jwkSetEndpointFilter), AbstractPreAuthenticatedProcessingFilter.class);
        }
    }

    private boolean isOidcEnabled() {
        return this.getConfigurer(OidcConfigurer.class) != null;
    }

    private Map<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> createConfigurers() {
        LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer> configurers = new LinkedHashMap<Class<? extends AbstractOAuth2Configurer>, AbstractOAuth2Configurer>();
        configurers.put(OAuth2ClientAuthenticationConfigurer.class, new OAuth2ClientAuthenticationConfigurer(x$0 -> this.postProcess(x$0)));
        configurers.put(OAuth2AuthorizationServerMetadataEndpointConfigurer.class, new OAuth2AuthorizationServerMetadataEndpointConfigurer(x$0 -> this.postProcess(x$0)));
        configurers.put(OAuth2AuthorizationEndpointConfigurer.class, new OAuth2AuthorizationEndpointConfigurer(x$0 -> this.postProcess(x$0)));
        configurers.put(OAuth2TokenEndpointConfigurer.class, new OAuth2TokenEndpointConfigurer(x$0 -> this.postProcess(x$0)));
        configurers.put(OAuth2TokenIntrospectionEndpointConfigurer.class, new OAuth2TokenIntrospectionEndpointConfigurer(x$0 -> this.postProcess(x$0)));
        configurers.put(OAuth2TokenRevocationEndpointConfigurer.class, new OAuth2TokenRevocationEndpointConfigurer(x$0 -> this.postProcess(x$0)));
        return configurers;
    }

    <T> T getConfigurer(Class<T> type) {
        return (T)this.configurers.get(type);
    }

    private <T extends AbstractOAuth2Configurer> void addConfigurer(Class<T> configurerType, T configurer) {
        this.configurers.put(configurerType, configurer);
    }

    private <T extends AbstractOAuth2Configurer> RequestMatcher getRequestMatcher(Class<T> configurerType) {
        AbstractOAuth2Configurer configurer = (AbstractOAuth2Configurer)this.getConfigurer(configurerType);
        return configurer != null ? configurer.getRequestMatcher() : null;
    }

    private static void validateAuthorizationServerSettings(AuthorizationServerSettings authorizationServerSettings) {
        if (authorizationServerSettings.getIssuer() != null) {
            URI issuerUri;
            try {
                issuerUri = new URI(authorizationServerSettings.getIssuer());
                issuerUri.toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("issuer must be a valid URL", ex);
            }
            if (issuerUri.getQuery() != null || issuerUri.getFragment() != null) {
                throw new IllegalArgumentException("issuer cannot contain query or fragment component");
            }
        }
    }

    private static void initSessionRegistry(HttpSecurity httpSecurity) {
        SessionRegistry sessionRegistry = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, SessionRegistry.class);
        if (sessionRegistry == null) {
            sessionRegistry = new SessionRegistryImpl();
            OAuth2AuthorizationServerConfigurer.registerDelegateApplicationListener(httpSecurity, (SessionRegistryImpl)sessionRegistry);
        }
        httpSecurity.setSharedObject(SessionRegistry.class, sessionRegistry);
    }

    private static void registerDelegateApplicationListener(HttpSecurity httpSecurity, ApplicationListener<?> delegate) {
        DelegatingApplicationListener delegatingApplicationListener = OAuth2ConfigurerUtils.getOptionalBean(httpSecurity, DelegatingApplicationListener.class);
        if (delegatingApplicationListener == null) {
            return;
        }
        GenericApplicationListenerAdapter smartListener = new GenericApplicationListenerAdapter(delegate);
        delegatingApplicationListener.addListener((SmartApplicationListener)smartListener);
    }
}

