/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.authentication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.encoding.LdapShaPasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.authentication.AbstractLdapAuthenticator;
import org.springframework.util.Assert;

public final class PasswordComparisonAuthenticator
extends AbstractLdapAuthenticator {
    private static final Log logger = LogFactory.getLog(PasswordComparisonAuthenticator.class);
    private org.springframework.security.authentication.encoding.PasswordEncoder passwordEncoder = new LdapShaPasswordEncoder();
    private String passwordAttributeName = "userPassword";
    private boolean usePasswordAttrCompare = false;

    public PasswordComparisonAuthenticator(BaseLdapPathContextSource contextSource) {
        super((ContextSource)contextSource);
    }

    public DirContextOperations authenticate(Authentication authentication) {
        Assert.isInstanceOf(UsernamePasswordAuthenticationToken.class, (Object)authentication, (String)"Can only process UsernamePasswordAuthenticationToken objects");
        DirContextOperations user = null;
        String username = authentication.getName();
        String password = (String)authentication.getCredentials();
        SpringSecurityLdapTemplate ldapTemplate = new SpringSecurityLdapTemplate(this.getContextSource());
        for (String userDn : this.getUserDns(username)) {
            try {
                user = ldapTemplate.retrieveEntry(userDn, this.getUserAttributes());
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (user == null) continue;
            break;
        }
        if (user == null && this.getUserSearch() != null) {
            user = this.getUserSearch().searchForUser(username);
        }
        if (user == null) {
            throw new UsernameNotFoundException("User not found: " + username);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Performing LDAP compare of password attribute '" + this.passwordAttributeName + "' for user '" + user.getDn() + "'"));
        }
        if (this.usePasswordAttrCompare && this.isPasswordAttrCompare(user, password)) {
            return user;
        }
        if (this.isLdapPasswordCompare(user, ldapTemplate, password)) {
            return user;
        }
        throw new BadCredentialsException(this.messages.getMessage("PasswordComparisonAuthenticator.badCredentials", "Bad credentials"));
    }

    private boolean isPasswordAttrCompare(DirContextOperations user, String password) {
        Object passwordAttrValue = user.getObjectAttribute(this.passwordAttributeName);
        return this.passwordEncoder.isPasswordValid(new String((byte[])passwordAttrValue), password, null);
    }

    private boolean isLdapPasswordCompare(DirContextOperations user, SpringSecurityLdapTemplate ldapTemplate, String password) {
        String encodedPassword = this.passwordEncoder.encodePassword(password, null);
        byte[] passwordBytes = Utf8.encode((CharSequence)encodedPassword);
        return ldapTemplate.compare(user.getDn().toString(), this.passwordAttributeName, passwordBytes);
    }

    public void setPasswordAttributeName(String passwordAttribute) {
        Assert.hasLength((String)passwordAttribute, (String)"passwordAttributeName must not be empty or null");
        this.passwordAttributeName = passwordAttribute;
    }

    private void setPasswordEncoder(org.springframework.security.authentication.encoding.PasswordEncoder passwordEncoder) {
        Assert.notNull((Object)passwordEncoder, (String)"passwordEncoder must not be null.");
        this.passwordEncoder = passwordEncoder;
    }

    public void setPasswordEncoder(Object passwordEncoder) {
        if (passwordEncoder instanceof org.springframework.security.authentication.encoding.PasswordEncoder) {
            this.usePasswordAttrCompare = false;
            this.setPasswordEncoder((org.springframework.security.authentication.encoding.PasswordEncoder)passwordEncoder);
            return;
        }
        if (passwordEncoder instanceof PasswordEncoder) {
            final PasswordEncoder delegate = (PasswordEncoder)passwordEncoder;
            this.setPasswordEncoder(new org.springframework.security.authentication.encoding.PasswordEncoder(){

                public String encodePassword(String rawPass, Object salt) {
                    this.checkSalt(salt);
                    return delegate.encode((CharSequence)rawPass);
                }

                public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
                    this.checkSalt(salt);
                    return delegate.matches((CharSequence)rawPass, encPass);
                }

                private void checkSalt(Object salt) {
                    Assert.isNull((Object)salt, (String)"Salt value must be null when used with crypto module PasswordEncoder");
                }
            });
            this.usePasswordAttrCompare = true;
            return;
        }
        throw new IllegalArgumentException("passwordEncoder must be a PasswordEncoder instance");
    }
}

