/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core;

import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.oauth2.core.OAuth2AuthorizationServerMetadataClaimAccessor;
import org.springframework.security.oauth2.core.Version;
import org.springframework.util.Assert;

public abstract class AbstractOAuth2AuthorizationServerMetadata
implements OAuth2AuthorizationServerMetadataClaimAccessor,
Serializable {
    private static final long serialVersionUID = Version.SERIAL_VERSION_UID;
    private final Map<String, Object> claims;

    protected AbstractOAuth2AuthorizationServerMetadata(Map<String, Object> claims) {
        Assert.notEmpty(claims, (String)"claims cannot be empty");
        this.claims = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(claims));
    }

    public Map<String, Object> getClaims() {
        return this.claims;
    }

    protected static abstract class AbstractBuilder<T extends AbstractOAuth2AuthorizationServerMetadata, B extends AbstractBuilder<T, B>> {
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        protected AbstractBuilder() {
        }

        protected Map<String, Object> getClaims() {
            return this.claims;
        }

        protected final B getThis() {
            return (B)this;
        }

        public B issuer(String issuer) {
            return this.claim("issuer", issuer);
        }

        public B authorizationEndpoint(String authorizationEndpoint) {
            return this.claim("authorization_endpoint", authorizationEndpoint);
        }

        public B tokenEndpoint(String tokenEndpoint) {
            return this.claim("token_endpoint", tokenEndpoint);
        }

        public B tokenEndpointAuthenticationMethod(String authenticationMethod) {
            this.addClaimToClaimList("token_endpoint_auth_methods_supported", authenticationMethod);
            return this.getThis();
        }

        public B tokenEndpointAuthenticationMethods(Consumer<List<String>> authenticationMethodsConsumer) {
            this.acceptClaimValues("token_endpoint_auth_methods_supported", authenticationMethodsConsumer);
            return this.getThis();
        }

        public B jwkSetUrl(String jwkSetUrl) {
            return this.claim("jwks_uri", jwkSetUrl);
        }

        public B scope(String scope) {
            this.addClaimToClaimList("scopes_supported", scope);
            return this.getThis();
        }

        public B scopes(Consumer<List<String>> scopesConsumer) {
            this.acceptClaimValues("scopes_supported", scopesConsumer);
            return this.getThis();
        }

        public B responseType(String responseType) {
            this.addClaimToClaimList("response_types_supported", responseType);
            return this.getThis();
        }

        public B responseTypes(Consumer<List<String>> responseTypesConsumer) {
            this.acceptClaimValues("response_types_supported", responseTypesConsumer);
            return this.getThis();
        }

        public B grantType(String grantType) {
            this.addClaimToClaimList("grant_types_supported", grantType);
            return this.getThis();
        }

        public B grantTypes(Consumer<List<String>> grantTypesConsumer) {
            this.acceptClaimValues("grant_types_supported", grantTypesConsumer);
            return this.getThis();
        }

        public B tokenRevocationEndpoint(String tokenRevocationEndpoint) {
            return this.claim("revocation_endpoint", tokenRevocationEndpoint);
        }

        public B tokenRevocationEndpointAuthenticationMethod(String authenticationMethod) {
            this.addClaimToClaimList("revocation_endpoint_auth_methods_supported", authenticationMethod);
            return this.getThis();
        }

        public B tokenRevocationEndpointAuthenticationMethods(Consumer<List<String>> authenticationMethodsConsumer) {
            this.acceptClaimValues("revocation_endpoint_auth_methods_supported", authenticationMethodsConsumer);
            return this.getThis();
        }

        public B tokenIntrospectionEndpoint(String tokenIntrospectionEndpoint) {
            return this.claim("introspection_endpoint", tokenIntrospectionEndpoint);
        }

        public B tokenIntrospectionEndpointAuthenticationMethod(String authenticationMethod) {
            this.addClaimToClaimList("introspection_endpoint_auth_methods_supported", authenticationMethod);
            return this.getThis();
        }

        public B tokenIntrospectionEndpointAuthenticationMethods(Consumer<List<String>> authenticationMethodsConsumer) {
            this.acceptClaimValues("introspection_endpoint_auth_methods_supported", authenticationMethodsConsumer);
            return this.getThis();
        }

        public B codeChallengeMethod(String codeChallengeMethod) {
            this.addClaimToClaimList("code_challenge_methods_supported", codeChallengeMethod);
            return this.getThis();
        }

        public B codeChallengeMethods(Consumer<List<String>> codeChallengeMethodsConsumer) {
            this.acceptClaimValues("code_challenge_methods_supported", codeChallengeMethodsConsumer);
            return this.getThis();
        }

        public B claim(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.claims.put(name, value);
            return this.getThis();
        }

        public B claims(Consumer<Map<String, Object>> claimsConsumer) {
            claimsConsumer.accept(this.claims);
            return this.getThis();
        }

        public abstract T build();

        protected void validate() {
            Assert.notNull((Object)this.getClaims().get("issuer"), (String)"issuer cannot be null");
            AbstractBuilder.validateURL(this.getClaims().get("issuer"), "issuer must be a valid URL");
            Assert.notNull((Object)this.getClaims().get("authorization_endpoint"), (String)"authorizationEndpoint cannot be null");
            AbstractBuilder.validateURL(this.getClaims().get("authorization_endpoint"), "authorizationEndpoint must be a valid URL");
            Assert.notNull((Object)this.getClaims().get("token_endpoint"), (String)"tokenEndpoint cannot be null");
            AbstractBuilder.validateURL(this.getClaims().get("token_endpoint"), "tokenEndpoint must be a valid URL");
            if (this.getClaims().get("token_endpoint_auth_methods_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.getClaims().get("token_endpoint_auth_methods_supported"), (String)"tokenEndpointAuthenticationMethods must be of type List");
                Assert.notEmpty((Collection)((List)this.getClaims().get("token_endpoint_auth_methods_supported")), (String)"tokenEndpointAuthenticationMethods cannot be empty");
            }
            if (this.getClaims().get("jwks_uri") != null) {
                AbstractBuilder.validateURL(this.getClaims().get("jwks_uri"), "jwksUri must be a valid URL");
            }
            if (this.getClaims().get("scopes_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.getClaims().get("scopes_supported"), (String)"scopes must be of type List");
                Assert.notEmpty((Collection)((List)this.getClaims().get("scopes_supported")), (String)"scopes cannot be empty");
            }
            Assert.notNull((Object)this.getClaims().get("response_types_supported"), (String)"responseTypes cannot be null");
            Assert.isInstanceOf(List.class, (Object)this.getClaims().get("response_types_supported"), (String)"responseTypes must be of type List");
            Assert.notEmpty((Collection)((List)this.getClaims().get("response_types_supported")), (String)"responseTypes cannot be empty");
            if (this.getClaims().get("grant_types_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.getClaims().get("grant_types_supported"), (String)"grantTypes must be of type List");
                Assert.notEmpty((Collection)((List)this.getClaims().get("grant_types_supported")), (String)"grantTypes cannot be empty");
            }
            if (this.getClaims().get("revocation_endpoint") != null) {
                AbstractBuilder.validateURL(this.getClaims().get("revocation_endpoint"), "tokenRevocationEndpoint must be a valid URL");
            }
            if (this.getClaims().get("revocation_endpoint_auth_methods_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.getClaims().get("revocation_endpoint_auth_methods_supported"), (String)"tokenRevocationEndpointAuthenticationMethods must be of type List");
                Assert.notEmpty((Collection)((List)this.getClaims().get("revocation_endpoint_auth_methods_supported")), (String)"tokenRevocationEndpointAuthenticationMethods cannot be empty");
            }
            if (this.getClaims().get("introspection_endpoint") != null) {
                AbstractBuilder.validateURL(this.getClaims().get("introspection_endpoint"), "tokenIntrospectionEndpoint must be a valid URL");
            }
            if (this.getClaims().get("introspection_endpoint_auth_methods_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.getClaims().get("introspection_endpoint_auth_methods_supported"), (String)"tokenIntrospectionEndpointAuthenticationMethods must be of type List");
                Assert.notEmpty((Collection)((List)this.getClaims().get("introspection_endpoint_auth_methods_supported")), (String)"tokenIntrospectionEndpointAuthenticationMethods cannot be empty");
            }
            if (this.getClaims().get("code_challenge_methods_supported") != null) {
                Assert.isInstanceOf(List.class, (Object)this.getClaims().get("code_challenge_methods_supported"), (String)"codeChallengeMethods must be of type List");
                Assert.notEmpty((Collection)((List)this.getClaims().get("code_challenge_methods_supported")), (String)"codeChallengeMethods cannot be empty");
            }
        }

        private void addClaimToClaimList(String name, String value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.getClaims().computeIfAbsent(name, k -> new LinkedList());
            ((List)this.getClaims().get(name)).add(value);
        }

        private void acceptClaimValues(String name, Consumer<List<String>> valuesConsumer) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull(valuesConsumer, (String)"valuesConsumer cannot be null");
            this.getClaims().computeIfAbsent(name, k -> new LinkedList());
            List values = (List)this.getClaims().get(name);
            valuesConsumer.accept(values);
        }

        private static void validateURL(Object url, String errorMessage) {
            if (URL.class.isAssignableFrom(url.getClass())) {
                return;
            }
            try {
                new URI(url.toString()).toURL();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(errorMessage, ex);
            }
        }
    }
}

