/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2TokenIntrospection;
import org.springframework.security.oauth2.jwt.JwtClaimAccessor;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenIntrospectionAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OAuth2TokenIntrospectionAuthenticationProvider
implements AuthenticationProvider {
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;

    public OAuth2TokenIntrospectionAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OAuth2TokenIntrospectionAuthenticationToken tokenIntrospectionAuthentication = (OAuth2TokenIntrospectionAuthenticationToken)authentication;
        OAuth2ClientAuthenticationToken clientPrincipal = OAuth2AuthenticationProviderUtils.getAuthenticatedClientElseThrowInvalidClient((Authentication)tokenIntrospectionAuthentication);
        OAuth2Authorization authorization = this.authorizationService.findByToken(tokenIntrospectionAuthentication.getToken(), null);
        if (authorization == null) {
            return tokenIntrospectionAuthentication;
        }
        OAuth2Authorization.Token<AbstractOAuth2Token> authorizedToken = authorization.getToken(tokenIntrospectionAuthentication.getToken());
        if (!authorizedToken.isActive()) {
            return new OAuth2TokenIntrospectionAuthenticationToken(tokenIntrospectionAuthentication.getToken(), (Authentication)clientPrincipal, OAuth2TokenIntrospection.builder().build());
        }
        RegisteredClient authorizedClient = this.registeredClientRepository.findById(authorization.getRegisteredClientId());
        OAuth2TokenIntrospection tokenClaims = OAuth2TokenIntrospectionAuthenticationProvider.withActiveTokenClaims(authorizedToken, authorizedClient);
        return new OAuth2TokenIntrospectionAuthenticationToken(authorizedToken.getToken().getTokenValue(), (Authentication)clientPrincipal, tokenClaims);
    }

    public boolean supports(Class<?> authentication) {
        return OAuth2TokenIntrospectionAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private static OAuth2TokenIntrospection withActiveTokenClaims(OAuth2Authorization.Token<AbstractOAuth2Token> authorizedToken, RegisteredClient authorizedClient) {
        OAuth2TokenIntrospection.Builder tokenClaims = OAuth2TokenIntrospection.builder(true).clientId(authorizedClient.getClientId());
        AbstractOAuth2Token token = authorizedToken.getToken();
        if (token.getIssuedAt() != null) {
            tokenClaims.issuedAt(token.getIssuedAt());
        }
        if (token.getExpiresAt() != null) {
            tokenClaims.expiresAt(token.getExpiresAt());
        }
        if (OAuth2AccessToken.class.isAssignableFrom(token.getClass())) {
            OAuth2AccessToken accessToken = (OAuth2AccessToken)token;
            tokenClaims.scopes(scopes -> scopes.addAll(accessToken.getScopes()));
            tokenClaims.tokenType(accessToken.getTokenType().getValue());
            Map<String, Object> claims = authorizedToken.getClaims();
            if (!CollectionUtils.isEmpty(claims)) {
                JwtClaimAccessor jwtClaims = () -> claims;
                Instant notBefore = jwtClaims.getNotBefore();
                if (notBefore != null) {
                    tokenClaims.notBefore(notBefore);
                }
                tokenClaims.subject(jwtClaims.getSubject());
                List audience = jwtClaims.getAudience();
                if (!CollectionUtils.isEmpty((Collection)audience)) {
                    tokenClaims.audiences(audiences -> audiences.addAll(audience));
                }
                tokenClaims.issuer(jwtClaims.getIssuer().toExternalForm());
                String jti = jwtClaims.getId();
                if (StringUtils.hasText((String)jti)) {
                    tokenClaims.id(jti);
                }
            }
        }
        return tokenClaims.build();
    }
}

