/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2TokenType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.core.oidc.OidcClientRegistration;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.ClientSettings;
import org.springframework.security.oauth2.server.authorization.config.TokenSettings;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcAuthenticationProviderUtils;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcClientRegistrationAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public final class OidcClientRegistrationAuthenticationProvider
implements AuthenticationProvider {
    private static final StringKeyGenerator CLIENT_ID_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 32);
    private static final StringKeyGenerator CLIENT_SECRET_GENERATOR = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 48);
    private static final String DEFAULT_AUTHORIZED_SCOPE = "client.create";
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;

    public OidcClientRegistrationAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OidcClientRegistrationAuthenticationToken clientRegistrationAuthentication = (OidcClientRegistrationAuthenticationToken)authentication;
        AbstractOAuth2TokenAuthenticationToken accessTokenAuthentication = null;
        if (AbstractOAuth2TokenAuthenticationToken.class.isAssignableFrom(clientRegistrationAuthentication.getPrincipal().getClass())) {
            accessTokenAuthentication = (AbstractOAuth2TokenAuthenticationToken)clientRegistrationAuthentication.getPrincipal();
        }
        if (accessTokenAuthentication == null || !accessTokenAuthentication.isAuthenticated()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        String accessTokenValue = accessTokenAuthentication.getToken().getTokenValue();
        OAuth2Authorization authorization = this.authorizationService.findByToken(accessTokenValue, OAuth2TokenType.ACCESS_TOKEN);
        if (authorization == null) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken = authorization.getAccessToken();
        if (!authorizedAccessToken.isActive()) {
            throw new OAuth2AuthenticationException("invalid_token");
        }
        if (!OidcClientRegistrationAuthenticationProvider.isAuthorized(authorizedAccessToken)) {
            throw new OAuth2AuthenticationException("insufficient_scope");
        }
        if (!OidcClientRegistrationAuthenticationProvider.isValidRedirectUris(clientRegistrationAuthentication.getClientRegistration().getRedirectUris())) {
            throw new OAuth2AuthenticationException("invalid_redirect_uri");
        }
        RegisteredClient registeredClient = OidcClientRegistrationAuthenticationProvider.create(clientRegistrationAuthentication.getClientRegistration());
        this.registeredClientRepository.save(registeredClient);
        authorization = OidcAuthenticationProviderUtils.invalidate(authorization, (AbstractOAuth2Token)authorizedAccessToken.getToken());
        if (authorization.getRefreshToken() != null) {
            authorization = OidcAuthenticationProviderUtils.invalidate(authorization, (AbstractOAuth2Token)authorization.getRefreshToken().getToken());
        }
        this.authorizationService.save(authorization);
        return new OidcClientRegistrationAuthenticationToken((Authentication)accessTokenAuthentication, OidcClientRegistrationAuthenticationProvider.convert(registeredClient));
    }

    public boolean supports(Class<?> authentication) {
        return OidcClientRegistrationAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private static boolean isAuthorized(OAuth2Authorization.Token<OAuth2AccessToken> authorizedAccessToken) {
        Object scope = authorizedAccessToken.getClaims().get("scope");
        return scope != null && ((Collection)scope).contains(DEFAULT_AUTHORIZED_SCOPE);
    }

    private static boolean isValidRedirectUris(List<String> redirectUris) {
        if (CollectionUtils.isEmpty(redirectUris)) {
            return true;
        }
        for (String redirectUri : redirectUris) {
            try {
                URI validRedirectUri = new URI(redirectUri);
                if (validRedirectUri.getFragment() == null) continue;
                return false;
            }
            catch (URISyntaxException ex) {
                return false;
            }
        }
        return true;
    }

    private static RegisteredClient create(OidcClientRegistration clientRegistration) {
        RegisteredClient.Builder builder = RegisteredClient.withId(UUID.randomUUID().toString()).clientId(CLIENT_ID_GENERATOR.generateKey()).clientIdIssuedAt(Instant.now()).clientSecret(CLIENT_SECRET_GENERATOR.generateKey()).clientName(clientRegistration.getClientName());
        if (ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue().equals(clientRegistration.getTokenEndpointAuthenticationMethod())) {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST);
        } else {
            builder.clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC);
        }
        builder.redirectUris(redirectUris -> redirectUris.addAll(clientRegistration.getRedirectUris()));
        if (!CollectionUtils.isEmpty(clientRegistration.getGrantTypes())) {
            builder.authorizationGrantTypes(authorizationGrantTypes -> clientRegistration.getGrantTypes().forEach(grantType -> authorizationGrantTypes.add(new AuthorizationGrantType(grantType))));
        } else {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (CollectionUtils.isEmpty(clientRegistration.getResponseTypes()) || clientRegistration.getResponseTypes().contains(OAuth2AuthorizationResponseType.CODE.getValue())) {
            builder.authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
        }
        if (!CollectionUtils.isEmpty(clientRegistration.getScopes())) {
            builder.scopes(scopes -> scopes.addAll(clientRegistration.getScopes()));
        }
        builder.clientSettings(ClientSettings.builder().requireProofKey(true).requireAuthorizationConsent(true).build()).tokenSettings(TokenSettings.builder().idTokenSignatureAlgorithm(SignatureAlgorithm.RS256).build());
        return builder.build();
    }

    private static OidcClientRegistration convert(RegisteredClient registeredClient) {
        OidcClientRegistration.Builder builder = OidcClientRegistration.builder().clientId(registeredClient.getClientId()).clientIdIssuedAt(registeredClient.getClientIdIssuedAt()).clientSecret(registeredClient.getClientSecret()).clientName(registeredClient.getClientName());
        builder.redirectUris(redirectUris -> redirectUris.addAll(registeredClient.getRedirectUris()));
        builder.grantTypes(grantTypes -> registeredClient.getAuthorizationGrantTypes().forEach(authorizationGrantType -> grantTypes.add(authorizationGrantType.getValue())));
        if (registeredClient.getAuthorizationGrantTypes().contains(AuthorizationGrantType.AUTHORIZATION_CODE)) {
            builder.responseType(OAuth2AuthorizationResponseType.CODE.getValue());
        }
        if (!CollectionUtils.isEmpty(registeredClient.getScopes())) {
            builder.scopes(scopes -> scopes.addAll(registeredClient.getScopes()));
        }
        builder.tokenEndpointAuthenticationMethod(registeredClient.getClientAuthenticationMethods().iterator().next().getValue()).idTokenSignedResponseAlgorithm(registeredClient.getTokenSettings().getIdTokenSignatureAlgorithm().getName());
        return builder.build();
    }
}

