/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.GsonHttpMessageConverter;
import org.springframework.http.converter.json.JsonbHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.endpoint.MapOAuth2AccessTokenResponseConverter;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AccessTokenResponseMapConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class OAuth2AccessTokenResponseHttpMessageConverter
extends AbstractHttpMessageConverter<OAuth2AccessTokenResponse> {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private GenericHttpMessageConverter<Object> jsonMessageConverter = HttpMessageConverters.getJsonMessageConverter();
    @Deprecated
    protected Converter<Map<String, String>, OAuth2AccessTokenResponse> tokenResponseConverter = new MapOAuth2AccessTokenResponseConverter();
    private Converter<Map<String, ?>, OAuth2AccessTokenResponse> accessTokenResponseConverter = new DefaultMapOAuth2AccessTokenResponseConverter();
    @Deprecated
    protected Converter<OAuth2AccessTokenResponse, Map<String, String>> tokenResponseParametersConverter = new OAuth2AccessTokenResponseMapConverter();
    private Converter<OAuth2AccessTokenResponse, Map<String, Object>> accessTokenResponseParametersConverter = new DefaultOAuth2AccessTokenResponseMapConverter();

    OAuth2AccessTokenResponseHttpMessageConverter() {
        super(DEFAULT_CHARSET, new MediaType[]{MediaType.APPLICATION_JSON, new MediaType("application", "*+json")});
    }

    protected boolean supports(Class<?> clazz) {
        return OAuth2AccessTokenResponse.class.isAssignableFrom(clazz);
    }

    protected OAuth2AccessTokenResponse readInternal(Class<? extends OAuth2AccessTokenResponse> clazz, HttpInputMessage inputMessage) throws HttpMessageNotReadableException {
        try {
            Map tokenResponseParameters = (Map)this.jsonMessageConverter.read(STRING_OBJECT_MAP.getType(), null, inputMessage);
            if (this.tokenResponseConverter.getClass() != MapOAuth2AccessTokenResponseConverter.class) {
                HashMap stringTokenResponseParameters = new HashMap();
                tokenResponseParameters.forEach((key, value) -> stringTokenResponseParameters.put(key, String.valueOf(value)));
                return (OAuth2AccessTokenResponse)this.tokenResponseConverter.convert(stringTokenResponseParameters);
            }
            return (OAuth2AccessTokenResponse)this.accessTokenResponseConverter.convert((Object)tokenResponseParameters);
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("An error occurred reading the OAuth 2.0 Access Token Response: " + ex.getMessage(), (Throwable)ex, inputMessage);
        }
    }

    protected void writeInternal(OAuth2AccessTokenResponse tokenResponse, HttpOutputMessage outputMessage) throws HttpMessageNotWritableException {
        try {
            LinkedHashMap tokenResponseParameters = this.tokenResponseParametersConverter.getClass() != OAuth2AccessTokenResponseMapConverter.class ? new LinkedHashMap((Map)this.tokenResponseParametersConverter.convert((Object)tokenResponse)) : (LinkedHashMap)this.accessTokenResponseParametersConverter.convert((Object)tokenResponse);
            this.jsonMessageConverter.write(tokenResponseParameters, STRING_OBJECT_MAP.getType(), MediaType.APPLICATION_JSON, outputMessage);
        }
        catch (Exception ex) {
            throw new HttpMessageNotWritableException("An error occurred writing the OAuth 2.0 Access Token Response: " + ex.getMessage(), (Throwable)ex);
        }
    }

    @Deprecated
    public final void setTokenResponseConverter(Converter<Map<String, String>, OAuth2AccessTokenResponse> tokenResponseConverter) {
        Assert.notNull(tokenResponseConverter, (String)"tokenResponseConverter cannot be null");
        this.tokenResponseConverter = tokenResponseConverter;
    }

    public final void setAccessTokenResponseConverter(Converter<Map<String, ?>, OAuth2AccessTokenResponse> accessTokenResponseConverter) {
        Assert.notNull(accessTokenResponseConverter, (String)"accessTokenResponseConverter cannot be null");
        this.accessTokenResponseConverter = accessTokenResponseConverter;
    }

    @Deprecated
    public final void setTokenResponseParametersConverter(Converter<OAuth2AccessTokenResponse, Map<String, String>> tokenResponseParametersConverter) {
        Assert.notNull(tokenResponseParametersConverter, (String)"tokenResponseParametersConverter cannot be null");
        this.tokenResponseParametersConverter = tokenResponseParametersConverter;
    }

    public final void setAccessTokenResponseParametersConverter(Converter<OAuth2AccessTokenResponse, Map<String, Object>> accessTokenResponseParametersConverter) {
        Assert.notNull(accessTokenResponseParametersConverter, (String)"accessTokenResponseParametersConverter cannot be null");
        this.accessTokenResponseParametersConverter = accessTokenResponseParametersConverter;
    }

    static final class DefaultOAuth2AccessTokenResponseMapConverter
    implements Converter<OAuth2AccessTokenResponse, Map<String, Object>> {
        DefaultOAuth2AccessTokenResponseMapConverter() {
        }

        public Map<String, Object> convert(OAuth2AccessTokenResponse tokenResponse) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("access_token", tokenResponse.getAccessToken().getTokenValue());
            parameters.put("token_type", tokenResponse.getAccessToken().getTokenType().getValue());
            parameters.put("expires_in", DefaultOAuth2AccessTokenResponseMapConverter.getExpiresIn(tokenResponse));
            if (!CollectionUtils.isEmpty((Collection)tokenResponse.getAccessToken().getScopes())) {
                parameters.put("scope", StringUtils.collectionToDelimitedString((Collection)tokenResponse.getAccessToken().getScopes(), (String)" "));
            }
            if (tokenResponse.getRefreshToken() != null) {
                parameters.put("refresh_token", tokenResponse.getRefreshToken().getTokenValue());
            }
            if (!CollectionUtils.isEmpty((Map)tokenResponse.getAdditionalParameters())) {
                for (Map.Entry entry : tokenResponse.getAdditionalParameters().entrySet()) {
                    parameters.put((String)entry.getKey(), entry.getValue());
                }
            }
            return parameters;
        }

        private static long getExpiresIn(OAuth2AccessTokenResponse tokenResponse) {
            if (tokenResponse.getAccessToken().getExpiresAt() != null) {
                return ChronoUnit.SECONDS.between(Instant.now(), tokenResponse.getAccessToken().getExpiresAt());
            }
            return -1L;
        }
    }

    static final class DefaultMapOAuth2AccessTokenResponseConverter
    implements Converter<Map<String, ?>, OAuth2AccessTokenResponse> {
        private static final Set<String> TOKEN_RESPONSE_PARAMETER_NAMES = new HashSet<String>(Arrays.asList("access_token", "expires_in", "refresh_token", "scope", "token_type"));

        DefaultMapOAuth2AccessTokenResponseConverter() {
        }

        public OAuth2AccessTokenResponse convert(Map<String, ?> source) {
            String accessToken = DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(source, "access_token");
            OAuth2AccessToken.TokenType accessTokenType = DefaultMapOAuth2AccessTokenResponseConverter.getAccessTokenType(source);
            long expiresIn = DefaultMapOAuth2AccessTokenResponseConverter.getExpiresIn(source);
            Set<String> scopes = DefaultMapOAuth2AccessTokenResponseConverter.getScopes(source);
            String refreshToken = DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(source, "refresh_token");
            LinkedHashMap additionalParameters = new LinkedHashMap();
            for (Map.Entry<String, ?> entry : source.entrySet()) {
                if (TOKEN_RESPONSE_PARAMETER_NAMES.contains(entry.getKey())) continue;
                additionalParameters.put(entry.getKey(), entry.getValue());
            }
            return OAuth2AccessTokenResponse.withToken((String)accessToken).tokenType(accessTokenType).expiresIn(expiresIn).scopes(scopes).refreshToken(refreshToken).additionalParameters(additionalParameters).build();
        }

        private static OAuth2AccessToken.TokenType getAccessTokenType(Map<String, ?> tokenResponseParameters) {
            if (OAuth2AccessToken.TokenType.BEARER.getValue().equalsIgnoreCase(DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(tokenResponseParameters, "token_type"))) {
                return OAuth2AccessToken.TokenType.BEARER;
            }
            return null;
        }

        private static long getExpiresIn(Map<String, ?> tokenResponseParameters) {
            return DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(tokenResponseParameters, "expires_in", 0L);
        }

        private static Set<String> getScopes(Map<String, ?> tokenResponseParameters) {
            if (tokenResponseParameters.containsKey("scope")) {
                String scope = DefaultMapOAuth2AccessTokenResponseConverter.getParameterValue(tokenResponseParameters, "scope");
                return new HashSet<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)scope, (String)" ")));
            }
            return Collections.emptySet();
        }

        private static String getParameterValue(Map<String, ?> tokenResponseParameters, String parameterName) {
            Object obj = tokenResponseParameters.get(parameterName);
            return obj != null ? obj.toString() : null;
        }

        private static long getParameterValue(Map<String, ?> tokenResponseParameters, String parameterName, long defaultValue) {
            long parameterValue = defaultValue;
            Object obj = tokenResponseParameters.get(parameterName);
            if (obj != null) {
                if (obj.getClass() == Long.class) {
                    parameterValue = (Long)obj;
                } else if (obj.getClass() == Integer.class) {
                    parameterValue = ((Integer)obj).intValue();
                } else {
                    try {
                        parameterValue = Long.parseLong(obj.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return parameterValue;
        }
    }

    static final class HttpMessageConverters {
        private static final boolean jackson2Present;
        private static final boolean gsonPresent;
        private static final boolean jsonbPresent;

        private HttpMessageConverters() {
        }

        static GenericHttpMessageConverter<Object> getJsonMessageConverter() {
            if (jackson2Present) {
                return new MappingJackson2HttpMessageConverter();
            }
            if (gsonPresent) {
                return new GsonHttpMessageConverter();
            }
            if (jsonbPresent) {
                return new JsonbHttpMessageConverter();
            }
            return null;
        }

        static {
            ClassLoader classLoader = HttpMessageConverters.class.getClassLoader();
            jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)classLoader) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)classLoader);
            gsonPresent = ClassUtils.isPresent((String)"com.google.gson.Gson", (ClassLoader)classLoader);
            jsonbPresent = ClassUtils.isPresent((String)"javax.json.bind.Jsonb", (ClassLoader)classLoader);
        }
    }
}

