/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthorizationServerMetadata;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.core.http.converter.OAuth2AuthorizationServerMetadataHttpMessageConverter;
import org.springframework.security.oauth2.server.authorization.config.ProviderSettings;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponentsBuilder;

public final class OAuth2AuthorizationServerMetadataEndpointFilter
extends OncePerRequestFilter {
    private static final String DEFAULT_OAUTH2_AUTHORIZATION_SERVER_METADATA_ENDPOINT_URI = "/.well-known/oauth-authorization-server";
    private final ProviderSettings providerSettings;
    private final RequestMatcher requestMatcher;
    private final OAuth2AuthorizationServerMetadataHttpMessageConverter authorizationServerMetadataHttpMessageConverter = new OAuth2AuthorizationServerMetadataHttpMessageConverter();

    public OAuth2AuthorizationServerMetadataEndpointFilter(ProviderSettings providerSettings) {
        Assert.notNull((Object)providerSettings, (String)"providerSettings cannot be null");
        this.providerSettings = providerSettings;
        this.requestMatcher = new AntPathRequestMatcher(DEFAULT_OAUTH2_AUTHORIZATION_SERVER_METADATA_ENDPOINT_URI, HttpMethod.GET.name());
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!this.requestMatcher.matches(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        OAuth2AuthorizationServerMetadata authorizationServerMetadata = ((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)((OAuth2AuthorizationServerMetadata.Builder)OAuth2AuthorizationServerMetadata.builder().issuer(this.providerSettings.getIssuer())).authorizationEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(this.providerSettings.getIssuer(), this.providerSettings.getAuthorizationEndpoint()))).tokenEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(this.providerSettings.getIssuer(), this.providerSettings.getTokenEndpoint()))).tokenEndpointAuthenticationMethods(OAuth2AuthorizationServerMetadataEndpointFilter.clientAuthenticationMethods())).jwkSetUrl(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(this.providerSettings.getIssuer(), this.providerSettings.getJwkSetEndpoint()))).responseType(OAuth2AuthorizationResponseType.CODE.getValue())).grantType(AuthorizationGrantType.AUTHORIZATION_CODE.getValue())).grantType(AuthorizationGrantType.CLIENT_CREDENTIALS.getValue())).grantType(AuthorizationGrantType.REFRESH_TOKEN.getValue())).tokenRevocationEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(this.providerSettings.getIssuer(), this.providerSettings.getTokenRevocationEndpoint()))).tokenRevocationEndpointAuthenticationMethods(OAuth2AuthorizationServerMetadataEndpointFilter.clientAuthenticationMethods())).tokenIntrospectionEndpoint(OAuth2AuthorizationServerMetadataEndpointFilter.asUrl(this.providerSettings.getIssuer(), this.providerSettings.getTokenIntrospectionEndpoint()))).tokenIntrospectionEndpointAuthenticationMethods(OAuth2AuthorizationServerMetadataEndpointFilter.clientAuthenticationMethods())).codeChallengeMethod("plain")).codeChallengeMethod("S256")).build();
        ServletServerHttpResponse httpResponse = new ServletServerHttpResponse(response);
        this.authorizationServerMetadataHttpMessageConverter.write(authorizationServerMetadata, MediaType.APPLICATION_JSON, (HttpOutputMessage)httpResponse);
    }

    private static Consumer<List<String>> clientAuthenticationMethods() {
        return authenticationMethods -> {
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_BASIC.getValue());
            authenticationMethods.add(ClientAuthenticationMethod.CLIENT_SECRET_POST.getValue());
        };
    }

    private static String asUrl(String issuer, String endpoint) {
        return UriComponentsBuilder.fromUriString((String)issuer).path(endpoint).toUriString();
    }
}

