/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public final class OAuth2AuthorizationCodeAuthenticationConverter
implements AuthenticationConverter {
    @Nullable
    public Authentication convert(HttpServletRequest request) {
        String redirectUri;
        String grantType = request.getParameter("grant_type");
        if (!AuthorizationGrantType.AUTHORIZATION_CODE.getValue().equals(grantType)) {
            return null;
        }
        Authentication clientPrincipal = SecurityContextHolder.getContext().getAuthentication();
        MultiValueMap<String, String> parameters = OAuth2EndpointUtils.getParameters(request);
        String code = (String)parameters.getFirst((Object)"code");
        if (!StringUtils.hasText((String)code) || ((List)parameters.get((Object)"code")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "code", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        if (StringUtils.hasText((String)(redirectUri = (String)parameters.getFirst((Object)"redirect_uri"))) && ((List)parameters.get((Object)"redirect_uri")).size() != 1) {
            OAuth2EndpointUtils.throwError("invalid_request", "redirect_uri", "https://datatracker.ietf.org/doc/html/rfc6749#section-5.2");
        }
        HashMap<String, Object> additionalParameters = new HashMap<String, Object>();
        parameters.forEach((key, value) -> {
            if (!(key.equals("grant_type") || key.equals("client_id") || key.equals("code") || key.equals("redirect_uri"))) {
                additionalParameters.put((String)key, value.get(0));
            }
        });
        return new OAuth2AuthorizationCodeAuthenticationToken(code, clientPrincipal, redirectUri, additionalParameters);
    }
}

