/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.security.oauth2.server.authorization.util.SpringAuthorizationServerVersion;
import org.springframework.util.Assert;

public abstract class AbstractSettings
implements Serializable {
    private static final long serialVersionUID = SpringAuthorizationServerVersion.SERIAL_VERSION_UID;
    private final Map<String, Object> settings;

    protected AbstractSettings(Map<String, Object> settings) {
        Assert.notEmpty(settings, (String)"settings cannot be empty");
        this.settings = Collections.unmodifiableMap(new HashMap<String, Object>(settings));
    }

    public <T> T getSetting(String name) {
        Assert.hasText((String)name, (String)"name cannot be empty");
        return (T)this.getSettings().get(name);
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractSettings that = (AbstractSettings)obj;
        return this.settings.equals(that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.settings);
    }

    public String toString() {
        return "AbstractSettings {settings=" + this.settings + "}";
    }

    protected static abstract class AbstractBuilder<T extends AbstractSettings, B extends AbstractBuilder<T, B>> {
        private final Map<String, Object> settings = new HashMap<String, Object>();

        protected AbstractBuilder() {
        }

        public B setting(String name, Object value) {
            Assert.hasText((String)name, (String)"name cannot be empty");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.getSettings().put(name, value);
            return this.getThis();
        }

        public B settings(Consumer<Map<String, Object>> settingsConsumer) {
            settingsConsumer.accept(this.getSettings());
            return this.getThis();
        }

        public abstract T build();

        protected final Map<String, Object> getSettings() {
            return this.settings;
        }

        protected final B getThis() {
            return (B)this;
        }
    }
}

