/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.aot.hint;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.BindingReflectionHintsRegistrar;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.jackson2.CoreJackson2Module;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.OidcUserInfo;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.oauth2.core.user.DefaultOAuth2User;
import org.springframework.security.oauth2.core.user.OAuth2UserAuthority;
import org.springframework.security.oauth2.server.authorization.JdbcOAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeActor;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2TokenExchangeCompositeAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.JdbcRegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.security.web.jackson2.WebServletJackson2Module;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.util.ClassUtils;

class OAuth2AuthorizationServerBeanRegistrationAotProcessor
implements BeanRegistrationAotProcessor {
    private boolean jackson2Contributed;

    OAuth2AuthorizationServerBeanRegistrationAotProcessor() {
    }

    public BeanRegistrationAotContribution processAheadOfTime(RegisteredBean registeredBean) {
        boolean isJdbcBasedOAuth2AuthorizationService = JdbcOAuth2AuthorizationService.class.isAssignableFrom(registeredBean.getBeanClass());
        boolean isJdbcBasedRegisteredClientRepository = JdbcRegisteredClientRepository.class.isAssignableFrom(registeredBean.getBeanClass());
        if ((isJdbcBasedOAuth2AuthorizationService || isJdbcBasedRegisteredClientRepository) && !this.jackson2Contributed) {
            Jackson2ConfigurationBeanRegistrationAotContribution jackson2Contribution = new Jackson2ConfigurationBeanRegistrationAotContribution();
            this.jackson2Contributed = true;
            return jackson2Contribution;
        }
        return null;
    }

    private static class Jackson2ConfigurationBeanRegistrationAotContribution
    implements BeanRegistrationAotContribution {
        private final BindingReflectionHintsRegistrar reflectionHintsRegistrar = new BindingReflectionHintsRegistrar();

        private Jackson2ConfigurationBeanRegistrationAotContribution() {
        }

        public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
            this.registerHints(generationContext.getRuntimeHints());
        }

        private void registerHints(RuntimeHints hints) {
            hints.reflection().registerType(Collections.class, new MemberCategory[]{MemberCategory.DECLARED_CLASSES});
            hints.reflection().registerType(HashSet.class, new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS});
            hints.reflection().registerTypes(Arrays.asList(TypeReference.of(AbstractAuthenticationToken.class), TypeReference.of(DefaultSavedRequest.Builder.class), TypeReference.of(WebAuthenticationDetails.class), TypeReference.of(UsernamePasswordAuthenticationToken.class), TypeReference.of(User.class), TypeReference.of(DefaultOidcUser.class), TypeReference.of(DefaultOAuth2User.class), TypeReference.of(OidcUserAuthority.class), TypeReference.of(OAuth2UserAuthority.class), TypeReference.of(SimpleGrantedAuthority.class), TypeReference.of(OidcIdToken.class), TypeReference.of(AbstractOAuth2Token.class), TypeReference.of(OidcUserInfo.class), TypeReference.of(OAuth2TokenExchangeActor.class), TypeReference.of(OAuth2AuthorizationRequest.class), TypeReference.of(OAuth2TokenExchangeCompositeAuthenticationToken.class), TypeReference.of(AuthorizationGrantType.class), TypeReference.of(OAuth2AuthorizationResponseType.class), TypeReference.of(OAuth2TokenFormat.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}));
            hints.reflection().registerTypes(Arrays.asList(TypeReference.of(CoreJackson2Module.class), TypeReference.of(WebServletJackson2Module.class), TypeReference.of(OAuth2AuthorizationServerJackson2Module.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}));
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.jackson2.UnmodifiableSetMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.jackson2.UnmodifiableListMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.jackson2.UnmodifiableMapMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.server.authorization.jackson2.UnmodifiableMapMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.server.authorization.jackson2.HashSetMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.web.jackson2.DefaultSavedRequestMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.web.jackson2.WebAuthenticationDetailsMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.jackson2.UsernamePasswordAuthenticationTokenMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.jackson2.UserMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.jackson2.SimpleGrantedAuthorityMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.server.authorization.jackson2.OAuth2TokenExchangeActorMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationRequestMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.server.authorization.jackson2.OAuth2TokenExchangeCompositeAuthenticationTokenMixin")});
            this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.server.authorization.jackson2.OAuth2TokenFormatMixin")});
            if (ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.registration.ClientRegistration", (ClassLoader)ClassUtils.getDefaultClassLoader())) {
                hints.reflection().registerTypes(Arrays.asList(TypeReference.of((String)"org.springframework.security.oauth2.client.jackson2.OAuth2ClientJackson2Module"), TypeReference.of((String)"org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken")), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}));
                this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.client.jackson2.OAuth2AuthenticationTokenMixin")});
                this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.client.jackson2.DefaultOidcUserMixin")});
                this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.client.jackson2.DefaultOAuth2UserMixin")});
                this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.client.jackson2.OidcUserAuthorityMixin")});
                this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.client.jackson2.OAuth2UserAuthorityMixin")});
                this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.client.jackson2.OidcIdTokenMixin")});
                this.reflectionHintsRegistrar.registerReflectionHints(hints.reflection(), new Type[]{Jackson2ConfigurationBeanRegistrationAotContribution.loadClass("org.springframework.security.oauth2.client.jackson2.OidcUserInfoMixin")});
            }
        }

        private static Class<?> loadClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

