/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.context.Context;
import org.springframework.util.Assert;

public interface OAuth2AuthenticationContext
extends Context {
    default public <T extends Authentication> T getAuthentication() {
        return (T)this.get(Authentication.class);
    }

    public static abstract class AbstractBuilder<T extends OAuth2AuthenticationContext, B extends AbstractBuilder<T, B>> {
        private final Map<Object, Object> context = new HashMap<Object, Object>();

        protected AbstractBuilder(Authentication authentication) {
            Assert.notNull((Object)authentication, (String)"authentication cannot be null");
            this.put(Authentication.class, authentication);
        }

        public B put(Object key, Object value) {
            Assert.notNull((Object)key, (String)"key cannot be null");
            Assert.notNull((Object)value, (String)"value cannot be null");
            this.getContext().put(key, value);
            return this.getThis();
        }

        public B context(Consumer<Map<Object, Object>> contextConsumer) {
            contextConsumer.accept(this.getContext());
            return this.getThis();
        }

        protected <V> V get(Object key) {
            return (V)this.getContext().get(key);
        }

        protected Map<Object, Object> getContext() {
            return this.context;
        }

        protected final B getThis() {
            return (B)this;
        }

        public abstract T build();
    }
}

