/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web.authentication;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.web.authentication.OAuth2EndpointUtils;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.util.StringUtils;

public final class ClientSecretBasicAuthenticationConverter
implements AuthenticationConverter {
    @Nullable
    public Authentication convert(HttpServletRequest request) {
        String clientSecret;
        String clientID;
        byte[] decodedCredentials;
        String header = request.getHeader("Authorization");
        if (header == null) {
            return null;
        }
        String[] parts = header.split("\\s");
        if (!parts[0].equalsIgnoreCase("Basic")) {
            return null;
        }
        if (parts.length != 2) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        try {
            decodedCredentials = Base64.getDecoder().decode(parts[1].getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException ex) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_request"), (Throwable)ex);
        }
        String credentialsString = new String(decodedCredentials, StandardCharsets.UTF_8);
        String[] credentials = credentialsString.split(":", 2);
        if (credentials.length != 2 || !StringUtils.hasText((String)credentials[0]) || !StringUtils.hasText((String)credentials[1])) {
            throw new OAuth2AuthenticationException("invalid_request");
        }
        try {
            clientID = URLDecoder.decode(credentials[0], StandardCharsets.UTF_8.name());
            clientSecret = URLDecoder.decode(credentials[1], StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            throw new OAuth2AuthenticationException(new OAuth2Error("invalid_request"), (Throwable)ex);
        }
        return new OAuth2ClientAuthenticationToken(clientID, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, clientSecret, OAuth2EndpointUtils.getParametersIfMatchesAuthorizationCodeGrantRequest(request, new String[0]));
    }
}

