/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.oidc.authentication;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationContext;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.oidc.authentication.OidcLogoutAuthenticationValidator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class OidcLogoutAuthenticationProvider
implements AuthenticationProvider {
    private static final OAuth2TokenType ID_TOKEN_TOKEN_TYPE = new OAuth2TokenType("id_token");
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RegisteredClientRepository registeredClientRepository;
    private final OAuth2AuthorizationService authorizationService;
    private final SessionRegistry sessionRegistry;
    private Consumer<OidcLogoutAuthenticationContext> authenticationValidator = new OidcLogoutAuthenticationValidator();

    public OidcLogoutAuthenticationProvider(RegisteredClientRepository registeredClientRepository, OAuth2AuthorizationService authorizationService, SessionRegistry sessionRegistry) {
        Assert.notNull((Object)registeredClientRepository, (String)"registeredClientRepository cannot be null");
        Assert.notNull((Object)authorizationService, (String)"authorizationService cannot be null");
        Assert.notNull((Object)sessionRegistry, (String)"sessionRegistry cannot be null");
        this.registeredClientRepository = registeredClientRepository;
        this.authorizationService = authorizationService;
        this.sessionRegistry = sessionRegistry;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        OidcIdToken idToken;
        List audClaim;
        OAuth2Authorization.Token<OidcIdToken> authorizedIdToken;
        OidcLogoutAuthenticationToken oidcLogoutAuthentication = (OidcLogoutAuthenticationToken)authentication;
        OAuth2Authorization authorization = this.authorizationService.findByToken(oidcLogoutAuthentication.getIdTokenHint(), ID_TOKEN_TOKEN_TYPE);
        if (authorization == null) {
            OidcLogoutAuthenticationProvider.throwError("invalid_token", "id_token_hint");
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved authorization with ID Token");
        }
        if ((authorizedIdToken = authorization.getToken(OidcIdToken.class)).isInvalidated() || authorizedIdToken.isBeforeUse()) {
            OidcLogoutAuthenticationProvider.throwError("invalid_token", "id_token_hint");
        }
        RegisteredClient registeredClient = this.registeredClientRepository.findById(authorization.getRegisteredClientId());
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Retrieved registered client");
        }
        if (CollectionUtils.isEmpty((Collection)(audClaim = (idToken = authorizedIdToken.getToken()).getAudience())) || !audClaim.contains(registeredClient.getClientId())) {
            OidcLogoutAuthenticationProvider.throwError("invalid_token", "aud");
        }
        if (StringUtils.hasText((String)oidcLogoutAuthentication.getClientId()) && !oidcLogoutAuthentication.getClientId().equals(registeredClient.getClientId())) {
            OidcLogoutAuthenticationProvider.throwError("invalid_request", "client_id");
        }
        OidcLogoutAuthenticationContext context = OidcLogoutAuthenticationContext.with(oidcLogoutAuthentication).registeredClient(registeredClient).build();
        this.authenticationValidator.accept(context);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Validated logout request parameters");
        }
        if (oidcLogoutAuthentication.isPrincipalAuthenticated()) {
            SessionInformation sessionInformation;
            Authentication currentUserPrincipal = (Authentication)oidcLogoutAuthentication.getPrincipal();
            Authentication authorizedUserPrincipal = (Authentication)authorization.getAttribute(Principal.class.getName());
            if (!StringUtils.hasText((String)idToken.getSubject()) || !currentUserPrincipal.getName().equals(authorizedUserPrincipal.getName())) {
                OidcLogoutAuthenticationProvider.throwError("invalid_token", "sub");
            }
            if (StringUtils.hasText((String)oidcLogoutAuthentication.getSessionId()) && (sessionInformation = this.findSessionInformation(currentUserPrincipal, oidcLogoutAuthentication.getSessionId())) != null) {
                String sessionIdHash;
                try {
                    sessionIdHash = OidcLogoutAuthenticationProvider.createHash(sessionInformation.getSessionId());
                }
                catch (NoSuchAlgorithmException ex) {
                    OAuth2Error error = new OAuth2Error("server_error", "Failed to compute hash for Session ID.", null);
                    throw new OAuth2AuthenticationException(error);
                }
                String sidClaim = (String)idToken.getClaim("sid");
                if (!StringUtils.hasText((String)sidClaim) || !sidClaim.equals(sessionIdHash)) {
                    OidcLogoutAuthenticationProvider.throwError("invalid_token", "sid");
                }
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Authenticated logout request");
        }
        return new OidcLogoutAuthenticationToken(idToken, (Authentication)oidcLogoutAuthentication.getPrincipal(), oidcLogoutAuthentication.getSessionId(), oidcLogoutAuthentication.getClientId(), oidcLogoutAuthentication.getPostLogoutRedirectUri(), oidcLogoutAuthentication.getState());
    }

    public boolean supports(Class<?> authentication) {
        return OidcLogoutAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setAuthenticationValidator(Consumer<OidcLogoutAuthenticationContext> authenticationValidator) {
        Assert.notNull(authenticationValidator, (String)"authenticationValidator cannot be null");
        this.authenticationValidator = authenticationValidator;
    }

    private SessionInformation findSessionInformation(Authentication principal, String sessionId) {
        List sessions = this.sessionRegistry.getAllSessions(principal.getPrincipal(), true);
        SessionInformation sessionInformation = null;
        if (!CollectionUtils.isEmpty((Collection)sessions)) {
            for (SessionInformation session : sessions) {
                if (!session.getSessionId().equals(sessionId)) continue;
                sessionInformation = session;
                break;
            }
        }
        return sessionInformation;
    }

    private static void throwError(String errorCode, String parameterName) {
        OAuth2Error error = new OAuth2Error(errorCode, "OpenID Connect 1.0 Logout Request Parameter: " + parameterName, "https://openid.net/specs/openid-connect-rpinitiated-1_0.html#ValidationAndErrorHandling");
        throw new OAuth2AuthenticationException(error);
    }

    private static String createHash(String value) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(value.getBytes(StandardCharsets.US_ASCII));
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }
}

