/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization;

import java.io.Serializable;
import org.springframework.util.Assert;

public final class OAuth2TokenType
implements Serializable {
    private static final long serialVersionUID = -9015673781220922768L;
    public static final OAuth2TokenType ACCESS_TOKEN = new OAuth2TokenType("access_token");
    public static final OAuth2TokenType REFRESH_TOKEN = new OAuth2TokenType("refresh_token");
    private final String value;

    public OAuth2TokenType(String value) {
        Assert.hasText((String)value, (String)"value cannot be empty");
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2TokenType that = (OAuth2TokenType)obj;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }
}

