/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public final class OAuth2ClientAuthenticationContext
implements OAuth2AuthenticationContext {
    private final Map<Object, Object> context;

    private OAuth2ClientAuthenticationContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public RegisteredClient getRegisteredClient() {
        return this.get(RegisteredClient.class);
    }

    public static Builder with(OAuth2ClientAuthenticationToken authentication) {
        return new Builder(authentication);
    }

    public static final class Builder
    extends OAuth2AuthenticationContext.AbstractBuilder<OAuth2ClientAuthenticationContext, Builder> {
        private Builder(OAuth2ClientAuthenticationToken authentication) {
            super((Authentication)authentication);
        }

        public Builder registeredClient(RegisteredClient registeredClient) {
            return (Builder)this.put(RegisteredClient.class, registeredClient);
        }

        @Override
        public OAuth2ClientAuthenticationContext build() {
            Assert.notNull(this.get(RegisteredClient.class), (String)"registeredClient cannot be null");
            return new OAuth2ClientAuthenticationContext(this.getContext());
        }
    }
}

