/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationConsent;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2AuthenticationContext;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2DeviceVerificationAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.util.Assert;

public final class OAuth2DeviceVerificationAuthenticationContext
implements OAuth2AuthenticationContext {
    private final Map<Object, Object> context;

    private OAuth2DeviceVerificationAuthenticationContext(Map<Object, Object> context) {
        this.context = Collections.unmodifiableMap(new HashMap<Object, Object>(context));
    }

    @Override
    @Nullable
    public <V> V get(Object key) {
        return (V)(this.hasKey(key) ? this.context.get(key) : null);
    }

    @Override
    public boolean hasKey(Object key) {
        Assert.notNull((Object)key, (String)"key cannot be null");
        return this.context.containsKey(key);
    }

    public RegisteredClient getRegisteredClient() {
        return this.get(RegisteredClient.class);
    }

    public OAuth2Authorization getAuthorization() {
        return this.get(OAuth2Authorization.class);
    }

    @Nullable
    public OAuth2AuthorizationConsent getAuthorizationConsent() {
        return this.get(OAuth2AuthorizationConsent.class);
    }

    public Set<String> getRequestedScopes() {
        Set<String> requestedScopes = (Set<String>)this.getAuthorization().getAttribute("scope");
        return requestedScopes != null ? requestedScopes : Collections.emptySet();
    }

    public static Builder with(OAuth2DeviceVerificationAuthenticationToken authentication) {
        return new Builder(authentication);
    }

    public static final class Builder
    extends OAuth2AuthenticationContext.AbstractBuilder<OAuth2DeviceVerificationAuthenticationContext, Builder> {
        private Builder(OAuth2DeviceVerificationAuthenticationToken authentication) {
            super((Authentication)authentication);
        }

        public Builder registeredClient(RegisteredClient registeredClient) {
            return (Builder)this.put(RegisteredClient.class, registeredClient);
        }

        public Builder authorization(OAuth2Authorization authorization) {
            return (Builder)this.put(OAuth2Authorization.class, authorization);
        }

        public Builder authorizationConsent(OAuth2AuthorizationConsent authorizationConsent) {
            return (Builder)this.put(OAuth2AuthorizationConsent.class, authorizationConsent);
        }

        @Override
        public OAuth2DeviceVerificationAuthenticationContext build() {
            Assert.notNull(this.get(RegisteredClient.class), (String)"registeredClient cannot be null");
            Assert.notNull(this.get(OAuth2Authorization.class), (String)"authorization cannot be null");
            return new OAuth2DeviceVerificationAuthenticationContext(this.getContext());
        }
    }
}

