/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.token;

import java.time.Clock;
import java.time.Instant;
import java.util.Base64;
import org.springframework.lang.Nullable;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.authentication.OAuth2ClientAuthenticationToken;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.util.Assert;

public final class OAuth2RefreshTokenGenerator
implements OAuth2TokenGenerator<OAuth2RefreshToken> {
    private final StringKeyGenerator refreshTokenGenerator = new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 96);
    private Clock clock = Clock.systemUTC();

    @Override
    @Nullable
    public OAuth2RefreshToken generate(OAuth2TokenContext context) {
        if (!OAuth2TokenType.REFRESH_TOKEN.equals(context.getTokenType())) {
            return null;
        }
        if (OAuth2RefreshTokenGenerator.isPublicClientForAuthorizationCodeGrant(context)) {
            return null;
        }
        Instant issuedAt = this.clock.instant();
        Instant expiresAt = issuedAt.plus(context.getRegisteredClient().getTokenSettings().getRefreshTokenTimeToLive());
        return new OAuth2RefreshToken(this.refreshTokenGenerator.generateKey(), issuedAt, expiresAt);
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"clock cannot be null");
        this.clock = clock;
    }

    private static boolean isPublicClientForAuthorizationCodeGrant(OAuth2TokenContext context) {
        Object object;
        if (AuthorizationGrantType.AUTHORIZATION_CODE.equals((Object)context.getAuthorizationGrantType()) && (object = context.getAuthorizationGrant().getPrincipal()) instanceof OAuth2ClientAuthenticationToken) {
            OAuth2ClientAuthenticationToken clientPrincipal = (OAuth2ClientAuthenticationToken)((Object)object);
            return clientPrincipal.getClientAuthenticationMethod().equals((Object)ClientAuthenticationMethod.NONE);
        }
        return false;
    }
}

