/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.authorization.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.security.core.Authentication;

final class DefaultConsentPage {
    private static final MediaType TEXT_HTML_UTF8 = new MediaType("text", "html", StandardCharsets.UTF_8);

    private DefaultConsentPage() {
    }

    static void displayConsent(HttpServletRequest request, HttpServletResponse response, String clientId, Authentication principal, Set<String> requestedScopes, Set<String> authorizedScopes, String state, Map<String, String> additionalParameters) throws IOException {
        String consentPage = DefaultConsentPage.generateConsentPage(request, clientId, principal, requestedScopes, authorizedScopes, state, additionalParameters);
        response.setContentType(TEXT_HTML_UTF8.toString());
        response.setContentLength(consentPage.getBytes(StandardCharsets.UTF_8).length);
        response.getWriter().write(consentPage);
    }

    private static String generateConsentPage(HttpServletRequest request, String clientId, Authentication principal, Set<String> requestedScopes, Set<String> authorizedScopes, String state, Map<String, String> additionalParameters) {
        HashSet<String> scopesToAuthorize = new HashSet<String>();
        HashSet<String> scopesPreviouslyAuthorized = new HashSet<String>();
        for (String scope : requestedScopes) {
            if (authorizedScopes.contains(scope)) {
                scopesPreviouslyAuthorized.add(scope);
                continue;
            }
            if (scope.equals("openid")) continue;
            scopesToAuthorize.add(scope);
        }
        String userCode = additionalParameters.get("user_code");
        StringBuilder builder = new StringBuilder();
        builder.append("<!DOCTYPE html>");
        builder.append("<html lang=\"en\">");
        builder.append("<head>");
        builder.append("    <meta charset=\"utf-8\">");
        builder.append("    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">");
        builder.append("    <link rel=\"stylesheet\" href=\"https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css\" integrity=\"sha384-JcKb8q3iqJ61gNV9KGb8thSsNjpSL0n8PARn9HuZOnIxN0hoP+VmmDGMN5t9UJ0Z\" crossorigin=\"anonymous\">");
        builder.append("    <title>Consent required</title>");
        builder.append("\t<script>");
        builder.append("\t\tfunction cancelConsent() {");
        builder.append("\t\t\tdocument.consent_form.reset();");
        builder.append("\t\t\tdocument.consent_form.submit();");
        builder.append("\t\t}");
        builder.append("\t</script>");
        builder.append("</head>");
        builder.append("<body>");
        builder.append("<div class=\"container\">");
        builder.append("    <div class=\"py-5\">");
        builder.append("        <h1 class=\"text-center\">Consent required</h1>");
        builder.append("    </div>");
        builder.append("    <div class=\"row\">");
        builder.append("        <div class=\"col text-center\">");
        builder.append("            <p><span class=\"font-weight-bold text-primary\">" + clientId + "</span> wants to access your account <span class=\"font-weight-bold\">" + principal.getName() + "</span></p>");
        builder.append("        </div>");
        builder.append("    </div>");
        if (userCode != null) {
            builder.append("    <div class=\"row\">");
            builder.append("        <div class=\"col text-center\">");
            builder.append("            <p class=\"alert alert-warning\">You have provided the code <span class=\"font-weight-bold\">" + userCode + "</span>. Verify that this code matches what is shown on your device.</p>");
            builder.append("        </div>");
            builder.append("    </div>");
        }
        builder.append("    <div class=\"row pb-3\">");
        builder.append("        <div class=\"col text-center\">");
        builder.append("            <p>The following permissions are requested by the above app.<br/>Please review these and consent if you approve.</p>");
        builder.append("        </div>");
        builder.append("    </div>");
        builder.append("    <div class=\"row\">");
        builder.append("        <div class=\"col text-center\">");
        builder.append("            <form name=\"consent_form\" method=\"post\" action=\"" + request.getRequestURI() + "\">");
        builder.append("                <input type=\"hidden\" name=\"client_id\" value=\"" + clientId + "\">");
        builder.append("                <input type=\"hidden\" name=\"state\" value=\"" + state + "\">");
        if (userCode != null) {
            builder.append("                <input type=\"hidden\" name=\"user_code\" value=\"" + userCode + "\">");
        }
        for (String scope : scopesToAuthorize) {
            builder.append("                <div class=\"form-group form-check py-1\">");
            builder.append("                    <input class=\"form-check-input\" type=\"checkbox\" name=\"scope\" value=\"" + scope + "\" id=\"" + scope + "\">");
            builder.append("                    <label class=\"form-check-label\" for=\"" + scope + "\">" + scope + "</label>");
            builder.append("                </div>");
        }
        if (!scopesPreviouslyAuthorized.isEmpty()) {
            builder.append("                <p>You have already granted the following permissions to the above app:</p>");
            for (String scope : scopesPreviouslyAuthorized) {
                builder.append("                <div class=\"form-group form-check py-1\">");
                builder.append("                    <input class=\"form-check-input\" type=\"checkbox\" name=\"scope\" id=\"" + scope + "\" checked disabled>");
                builder.append("                    <label class=\"form-check-label\" for=\"" + scope + "\">" + scope + "</label>");
                builder.append("                </div>");
            }
        }
        builder.append("                <div class=\"form-group pt-3\">");
        builder.append("                    <button class=\"btn btn-primary btn-lg\" type=\"submit\" id=\"submit-consent\">Submit Consent</button>");
        builder.append("                </div>");
        builder.append("                <div class=\"form-group\">");
        builder.append("                    <button class=\"btn btn-link regular\" type=\"button\" onclick=\"cancelConsent();\" id=\"cancel-consent\">Cancel</button>");
        builder.append("                </div>");
        builder.append("            </form>");
        builder.append("        </div>");
        builder.append("    </div>");
        builder.append("    <div class=\"row pt-4\">");
        builder.append("        <div class=\"col text-center\">");
        builder.append("            <p><small>Your consent to provide access is required.<br/>If you do not approve, click Cancel, in which case no information will be shared with the app.</small></p>");
        builder.append("        </div>");
        builder.append("    </div>");
        builder.append("</div>");
        builder.append("</body>");
        builder.append("</html>");
        return builder.toString();
    }
}

